/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.magic;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractContinousCostMagicSpellTrait;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.friend.TargetType;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public abstract class AbstractMagicAuraSpellTrait
extends AbstractContinousCostMagicSpellTrait {
    private double range = 10.0;
    private TargetType target = TargetType.ALL;

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(classToExpect=Double.class, fieldName="range", optional=true), @TraitConfigurationField(classToExpect=String.class, fieldName="tagetType", optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("range")) {
            double range;
            this.range = range = configMap.getAsDouble("range");
        }
        if (configMap.containsKey("targetType")) {
            String typeName = configMap.getAsString("targetType");
            try {
                this.target = TargetType.valueOf(typeName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean activateIntern(RaCPlayer player) {
        return true;
    }

    @Override
    protected boolean deactivateIntern(RaCPlayer player) {
        return true;
    }

    @Override
    protected boolean tickInternal(RaCPlayer player) {
        if (!player.isOnline()) {
            return false;
        }
        List<Entity> nearby = SearchEntity.inCircleAround((Entity)player.getPlayer(), this.range);
        for (Entity entity : nearby) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity casted = (LivingEntity)entity;
            if (!EnemyChecker.isApplyable((Entity)player.getPlayer(), (Entity)casted, this.target)) continue;
            this.tickOnEntity((Entity)casted);
        }
        return true;
    }

    protected abstract void tickOnEntity(Entity var1);
}

