/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.magic;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.ContinousCostMagicTrait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.helper.ParticleHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class AbstractContinousCostMagicSpellTrait
extends AbstractMagicSpellTrait
implements ContinousCostMagicTrait {
    protected int everyXSeconds = -1;
    protected int durationInSeconds = -1;
    protected Map<UUID, Integer> activePlayersSchedulerMap = new HashMap<UUID, Integer>();

    @Override
    public final int everyXSeconds() {
        return this.everyXSeconds;
    }

    @Override
    public final boolean activate(final RaCPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.isActivated(player)) {
            return false;
        }
        if (!this.activateIntern(player)) {
            return false;
        }
        int tickDuration = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        tickDuration = (int)((double)tickDuration / this.getModValue(player, "duration"));
        this.tick(player, true, true);
        int bukkitID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!AbstractContinousCostMagicSpellTrait.this.tick(player, true, false)) {
                    AbstractContinousCostMagicSpellTrait.this.deactivate(player);
                    return;
                }
            }
        }, (long)(tickDuration * 20), (long)(tickDuration * 20));
        LanguageAPI.sendTranslatedMessage(player, "magic_spell_activated", "trait_name", this.getDisplayName());
        this.activePlayersSchedulerMap.put(player.getUniqueId(), bukkitID);
        return true;
    }

    protected abstract boolean activateIntern(RaCPlayer var1);

    @Override
    public final boolean deactivate(RaCPlayer player) {
        if (player == null) {
            return false;
        }
        if (!this.isActivated(player)) {
            return false;
        }
        if (!this.deactivateIntern(player)) {
            return false;
        }
        int schedulerID = this.activePlayersSchedulerMap.remove(player.getUniqueId());
        Bukkit.getScheduler().cancelTask(schedulerID);
        player.sendTranslatedMessage("magic_spell_deactivated", "trait_name", this.getDisplayName());
        return true;
    }

    protected abstract boolean deactivateIntern(RaCPlayer var1);

    @Override
    public final boolean isActivated(RaCPlayer player) {
        if (player == null) {
            return false;
        }
        return this.activePlayersSchedulerMap.containsKey(player.getUniqueId());
    }

    @Override
    protected final void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        if (this.everyXSeconds < 1) {
            result.setRemoveCostsAfterTrigger(this.activate(player));
            return;
        }
        if (this.isActivated(player)) {
            this.deactivate(player);
            result.setRemoveCostsAfterTrigger(false).setTriggered(true).setSetCooldownOnPositiveTrigger(true);
            return;
        }
        this.activate(player);
        result.setRemoveCostsAfterTrigger(true).setTriggered(true).setSetCooldownOnPositiveTrigger(false);
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() == PlayerAction.CAST_SPELL && this.isActivated(wrapper.getPlayer())) {
            this.deactivate(wrapper.getPlayer());
            return true;
        }
        return super.triggerButHasUplink(wrapper);
    }

    @Override
    public void triggerButDoesNotHaveEnoghCostType(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() == PlayerAction.CAST_SPELL && this.isActivated(wrapper.getPlayer())) {
            this.deactivate(wrapper.getPlayer());
            return;
        }
        super.triggerButDoesNotHaveEnoghCostType(wrapper);
    }

    protected final boolean tick(RaCPlayer player, boolean checkRemoveCost, boolean bypassEverySecondCheck) {
        if (!bypassEverySecondCheck && this.everyXSeconds <= 0) {
            this.setCooldownIfNeeded(player);
            return false;
        }
        if (checkRemoveCost && !player.getSpellManager().canCastSpell(this)) {
            return false;
        }
        boolean worked = this.tickInternal(player);
        if (checkRemoveCost && worked) {
            player.getSpellManager().removeCost(this);
        }
        return worked;
    }

    protected abstract boolean tickInternal(RaCPlayer var1);

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="every", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="duration", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("every")) {
            this.everyXSeconds = configMap.getAsInt("every");
        }
        if (configMap.containsKey("duration")) {
            this.durationInSeconds = configMap.getAsInt("duration");
        }
        if (this.everyXSeconds <= 0 && this.durationInSeconds <= 0) {
            throw new TraitConfigurationFailedException("Trait: " + this.getDisplayName() + " needs either 'every' or 'duration'. " + "None of them with a positive value was found. Please fix this.");
        }
    }

    @Override
    public void gotKicked(UUID player) {
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        if (this.deactivate(racPlayer) && racPlayer.isOnline()) {
            ParticleHelper.sendXParticleEffectToAllWithRandWidth(ParticleEffects.CRIT, racPlayer.getPlayer().getEyeLocation(), 0.0f, 10);
            racPlayer.sendTranslatedMessage("trait_kicked", "name", this.getName());
        }
        super.gotKicked(player);
    }
}

