/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.totem.PotionTotemTrait;

import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractTotemTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionTotemTrait
extends AbstractTotemTrait {
    private int amplifier = 1;
    private int effectId = 0;
    private PotionEffectType effect = null;

    @Override
    public String getName() {
        return "PotionTotemTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="effect", classToExpect=Integer.class, optional=false), @TraitConfigurationField(fieldName="amplifier", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("effect")) {
            this.effectId = (Integer)configMap.get("effect");
            this.effect = PotionEffectType.getById((int)this.effectId);
        }
        if (configMap.containsKey("amplifier")) {
            this.amplifier = (Integer)configMap.get("amplifier");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This Trait places a totem on the ground that applies a potion effect.");
        return helpList;
    }

    @Override
    @TraitInfos(category="totem", traitName="PotionTotemTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    protected void tickOnPlayer(AbstractTotemTrait.TotemInfos infos, Player player) {
        if (this.effect == null) {
            return;
        }
        int modAmp = this.modifyToPlayer(infos.getOwner(), this.amplifier, "amplifier");
        PotionEffect toApply = new PotionEffect(this.effect, 40, modAmp);
        player.addPotionEffect(toApply);
    }

    @Override
    protected void tickOnNonPlayer(AbstractTotemTrait.TotemInfos infos, LivingEntity entity) {
        if (this.effect == null) {
            return;
        }
        int modAmp = this.modifyToPlayer(infos.getOwner(), this.amplifier, "potion");
        PotionEffect toApply = new PotionEffect(this.effect, 40, modAmp);
        entity.addPotionEffect(toApply);
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Applies " + this.effect + " every " + this.tickEvery / 20;
    }
}

