/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.totem.HealTotemTrait;

import de.tobiyas.racesandclasses.eventprocessing.events.entitydamage.EntityHealOtherEntityEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractTotemTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.friend.TargetType;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class HealTotemTrait
extends AbstractTotemTrait {
    private double value = 1.0;

    @Override
    public String getName() {
        return "HealTotemTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class, optional=false)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("value")) {
            this.value = (Double)configMap.get("value");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This Trait places a totem on the ground that heals everyone in range.");
        return helpList;
    }

    @Override
    @TraitInfos(category="totem", traitName="HealTotemTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    protected void tickOnPlayer(AbstractTotemTrait.TotemInfos infos, Player player) {
        RaCPlayer owner = infos.getOwner();
        double modValue = this.modifyToPlayer(owner, this.value, "value");
        EntityHealOtherEntityEvent event = new EntityHealOtherEntityEvent((Entity)player, modValue, EntityRegainHealthEvent.RegainReason.MAGIC_REGEN, (Entity)owner.getPlayer());
        this.plugin.fireEventToBukkit((Event)event);
        if (event.isCancelled() || event.getAmount() <= 0.0) {
            return;
        }
        CompatibilityModifier.BukkitPlayer.safeHeal(event.getAmount(), player);
        player.getLocation().getWorld().playEffect(player.getLocation().add(0.0, 1.0, 0.0), Effect.ENDER_SIGNAL, 0);
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Heals " + this.value + " every " + this.tickEvery / 20;
    }

    @Override
    protected void tickOnNonPlayer(AbstractTotemTrait.TotemInfos infos, LivingEntity entity) {
        if (this.target == TargetType.FRIEND) {
            return;
        }
        RaCPlayer owner = infos.getOwner();
        EntityHealOtherEntityEvent event = new EntityHealOtherEntityEvent((Entity)entity, this.value, EntityRegainHealthEvent.RegainReason.MAGIC_REGEN, (Entity)owner.getPlayer());
        this.plugin.fireEventToBukkit((Event)event);
        if (event.isCancelled() || event.getAmount() <= 0.0) {
            return;
        }
        CompatibilityModifier.LivingEntity.safeHealEntity(entity, event.getAmount());
        entity.getLocation().getWorld().playEffect(entity.getLocation().add(0.0, 1.0, 0.0), Effect.ENDER_SIGNAL, 0);
    }
}

