/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.VampirismTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class VampirismTrait
extends AbstractPassiveTrait {
    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "VampirismTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf((int)(this.value * 100.0)) + "% regain from Damage";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = configMap.getAsDouble("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        double damage = CompatibilityModifier.EntityDamage.safeGetDamage((EntityDamageEvent)Eevent);
        boolean isArrow = eventWrapper.isArrowInvolved();
        Player damager = (Player)(isArrow ? ((Projectile)Eevent.getDamager()).getShooter() : Eevent.getDamager());
        double regain = damage * this.modifyToPlayer(eventWrapper.getPlayer(), this.value, "value");
        EntityRegainHealthEvent healEvent = new EntityRegainHealthEvent((Entity)damager, regain, EntityRegainHealthEvent.RegainReason.MAGIC);
        regain = CompatibilityModifier.EntityRegainHealth.safeGetAmount(healEvent);
        double before = CompatibilityModifier.BukkitPlayer.safeGetHealth(damager);
        if (regain > 0.0) {
            CompatibilityModifier.BukkitPlayer.safeHeal(regain, damager);
        } else {
            CompatibilityModifier.BukkitPlayer.safeDamage(-regain, damager);
        }
        double after = CompatibilityModifier.BukkitPlayer.safeGetHealth(damager);
        if (Math.abs(before - after) > 0.001 && Eevent.getEntity() instanceof LivingEntity) {
            LivingEntity damagee = (LivingEntity)Eevent.getEntity();
            damagee.getWorld().playEffect(damagee.getEyeLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_WIRE);
        }
        return TraitResults.True();
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof VampirismTrait)) {
            return false;
        }
        VampirismTrait otherTrait = (VampirismTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="VampirismTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait heals you by percentage of damage you do.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return wrapper.getPlayerAction() == PlayerAction.DO_DAMAGE;
    }
}

