/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.UnderwaterBreathTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.ByPassWorldDisabledCheck;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.BypassHolderCheck;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.RemoveSuperConfigField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;

@BypassHolderCheck
@ByPassWorldDisabledCheck
public class UnderwaterBreathTrait
extends TickEverySecondsTrait {
    private final int DEFAULT_BREATH_TIME = 300;
    private int newTimeInTicks = 300;
    private final Map<String, AirStorage> currentTicks = new HashMap<String, AirStorage>();

    @Override
    @TraitInfos(category="passive", traitName="UnderwaterBreathTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        super.generalInit();
    }

    @Override
    public String getName() {
        return "UnderwaterBreathTrait";
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof UnderwaterBreathTrait)) {
            return false;
        }
        UnderwaterBreathTrait otherTrait = (UnderwaterBreathTrait)trait;
        return this.newTimeInTicks >= otherTrait.newTimeInTicks;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="time", classToExpect=Integer.class)}, removedFields={@RemoveSuperConfigField(name="seconds")})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        configMap.put("seconds", (Object)1);
        super.setConfiguration(configMap);
        if (configMap.containsKey("time")) {
            this.newTimeInTicks = 20 * (Integer)configMap.get("time");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait modifies the time you can stay underwater.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return true;
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        if (player == null || !player.isOnline()) {
            return false;
        }
        if (player.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return false;
        }
        String playerName = player.getName();
        int currentBreath = player.getPlayer().getRemainingAir();
        if (!this.currentTicks.containsKey(playerName)) {
            AirStorage storage = new AirStorage();
            storage.currentScaledAir = currentBreath;
            storage.currentRawAir = currentBreath * (this.newTimeInTicks / 300);
            this.currentTicks.put(playerName, storage);
        }
        AirStorage playerStorage = this.currentTicks.get(playerName);
        int changeRatio = currentBreath - playerStorage.currentScaledAir;
        if (changeRatio == 0) {
            return false;
        }
        if (changeRatio > 0) {
            playerStorage.currentRawAir += (int)((double)changeRatio * ((double)this.newTimeInTicks / 300.0));
            if (playerStorage.currentRawAir > this.newTimeInTicks) {
                playerStorage.currentRawAir = this.newTimeInTicks;
            }
        }
        if (changeRatio < 0) {
            if (playerStorage.currentRawAir < 0) {
                playerStorage.currentRawAir = 0;
            }
            playerStorage.currentRawAir -= 20;
        }
        playerStorage.currentScaledAir = (int)((double)playerStorage.currentRawAir * (300.0 / (double)this.newTimeInTicks));
        player.getPlayer().setRemainingAir(playerStorage.currentScaledAir);
        return false;
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "you can breath for " + this.newTimeInTicks / 20 + " Seconds";
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "";
    }

    private static class AirStorage {
        protected int currentScaledAir = 0;
        protected int currentRawAir = 0;

        private AirStorage() {
        }
    }
}

