/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.ToolTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.MCPrettyName;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.Cancellable;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ToolTrait
extends AbstractPassiveTrait {
    private List<Material> allowed = new LinkedList<Material>();
    private List<Material> forbidden = new LinkedList<Material>();
    private boolean allowNonForbidden = true;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class, EntityDamageByEntityEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "ToolTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        String forbidden = "Forbidden: ";
        for (Material forbid : this.forbidden) {
            String name = MCPrettyName.getPrettyName(forbid);
            forbidden = String.valueOf(forbidden) + Character.toString(name.charAt(0)).toUpperCase() + name.toLowerCase().substring(1) + ", ";
        }
        if (forbidden.isEmpty()) {
            forbidden = String.valueOf(forbidden) + " None.  ";
        }
        return forbidden.substring(0, forbidden.length() - 2);
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="tools", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="allowNonForbidden", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.forbidden.clear();
        this.allowed.clear();
        if (configMap.containsKey("tools")) {
            List<String> toParse = configMap.getAsStringList("tools");
            for (String matName : toParse) {
                if (matName == null || matName.isEmpty()) continue;
                boolean notAllowed = matName.charAt(0) == '-';
                matName = matName.replace("+", "").replace("-", "").toUpperCase();
                try {
                    Material mat = Material.matchMaterial((String)matName);
                    if (mat == null) continue;
                    if (notAllowed) {
                        this.forbidden.add(mat);
                        continue;
                    }
                    this.allowed.add(mat);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (configMap.containsKey("allowNonForbidden")) {
            this.allowNonForbidden = configMap.getAsBool("allowNonForbidden");
        }
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        ItemStack interactingWith = null;
        PlayerInventory inv = eventWrapper.getPlayer().getPlayer().getInventory();
        if (eventWrapper.getPlayer() != null) {
            interactingWith = inv.getItem(inv.getHeldItemSlot());
        }
        if (interactingWith == null) {
            return TraitResults.False();
        }
        if (this.isOnForbidList(interactingWith)) {
            Cancellable event = (Cancellable)eventWrapper.getEvent();
            event.setCancelled(true);
            LanguageAPI.sendTranslatedMessage(eventWrapper.getPlayer(), "trait_tool_trait_fail");
            return TraitResults.False();
        }
        if (!this.isOnAllowList(interactingWith) && !this.allowNonForbidden) {
            Cancellable event = (Cancellable)eventWrapper.getEvent();
            event.setCancelled(true);
            LanguageAPI.sendTranslatedMessage(eventWrapper.getPlayer(), "trait_tool_trait_fail");
            return TraitResults.False();
        }
        return TraitResults.True();
    }

    private boolean isOnAllowList(ItemStack interactingWith) {
        if (this.allowNonForbidden) {
            return false;
        }
        Material mat = interactingWith.getType();
        return !this.allowed.contains(mat);
    }

    private boolean isOnForbidList(ItemStack interactingWith) {
        return this.forbidden.contains(interactingWith.getType());
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.RED + "Nothing to see here yet.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    @Override
    @TraitInfos(category="passive", traitName="ToolTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        PlayerAction action = wrapper.getPlayerAction();
        return action == PlayerAction.DO_DAMAGE || action == PlayerAction.INTERACT_BLOCK || action == PlayerAction.INTERACT_AIR || action == PlayerAction.INTERACT_ENTITY;
    }
}

