/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.SwimmingSpeedTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.HolderSelectedEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.RemoveSuperConfigField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.inventory.InventoryResync;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SwimmingSpeedTrait
extends TickEverySecondsTrait {
    private int level = 3;
    private boolean generateNewBootsIfNotPresent = false;
    private Set<UUID> playerWithOpenedInventories = new HashSet<UUID>();
    private Set<UUID> playerWithActiveEnchants = new HashSet<UUID>();
    private Set<UUID> playerWithGeneratedBoots = new HashSet<UUID>();

    @Override
    @TraitEventsUsed(registerdClasses={PlayerJoinEvent.class, HolderSelectedEvent.class})
    public void generalInit() {
        super.generalInit();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public String getName() {
        return "SwimmingSpeedTrait";
    }

    @Override
    @TraitInfos(category="passive", traitName="SwimmingSpeedTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (trait instanceof SwimmingSpeedTrait) {
            return this.level > ((SwimmingSpeedTrait)trait).level;
        }
        return false;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="level", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="generateNewBoots", classToExpect=Boolean.class, optional=true)}, removedFields={@RemoveSuperConfigField(name="seconds")})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        configMap.put("seconds", (Object)1);
        super.setConfiguration(configMap);
        if (configMap.containsKey("level")) {
            this.level = configMap.getAsInt("level");
        }
        if (configMap.containsKey("generateNewBoots")) {
            this.generateNewBootsIfNotPresent = configMap.getAsBool("generateNewBoots");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait changes (increases or decreases) the movement speed of a Player underwater.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        boolean canBeTriggered = super.canBeTriggered(wrapper);
        if (!canBeTriggered) {
            this.removeEnchant(wrapper.getPlayer());
            this.playerWithActiveEnchants.remove(wrapper.getPlayer().getUniqueId());
            return false;
        }
        return true;
    }

    private void removeEnchant(RaCPlayer racPlayer) {
        if (!racPlayer.isOnline()) {
            return;
        }
        Player player = racPlayer.getPlayer();
        ItemStack boots = player.getInventory().getBoots();
        if (boots == null || boots.getType() == Material.AIR) {
            return;
        }
        boots.removeEnchantment(Enchantment.DEPTH_STRIDER);
        if (this.playerWithGeneratedBoots.contains(racPlayer.getUniqueId())) {
            boots = null;
            this.playerWithGeneratedBoots.remove(player.getUniqueId());
        }
        player.getInventory().setBoots(boots);
    }

    private void addEnchant(RaCPlayer racPlayer) {
        if (!racPlayer.isOnline()) {
            return;
        }
        Player player = racPlayer.getPlayer();
        ItemStack boots = player.getInventory().getBoots();
        if (boots == null || boots.getType() == Material.AIR) {
            if (!this.generateNewBootsIfNotPresent) {
                return;
            }
            boots = new ItemStack(Material.LEATHER_BOOTS);
            this.playerWithGeneratedBoots.add(player.getUniqueId());
        }
        if (boots.getEnchantmentLevel(Enchantment.DEPTH_STRIDER) > 0) {
            this.playerWithActiveEnchants.remove(racPlayer.getUniqueId());
            return;
        }
        boots.addUnsafeEnchantment(Enchantment.DEPTH_STRIDER, this.level);
        player.getInventory().setBoots(boots);
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Swims " + this.level + "x faster underwater";
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        if (!player.isOnline()) {
            return false;
        }
        Location playerLocation = player.getLocation();
        Material standingIn = playerLocation.getBlock().getType();
        if (this.playerWithOpenedInventories.contains(player.getUniqueId())) {
            return false;
        }
        boolean alreadyOnList = this.playerWithActiveEnchants.contains(player.getUniqueId());
        boolean isLiquid = false;
        if (standingIn == Material.WATER || standingIn == Material.STATIONARY_WATER || standingIn == Material.LAVA || standingIn == Material.STATIONARY_LAVA) {
            isLiquid = true;
        }
        if (alreadyOnList && !isLiquid) {
            this.playerWithActiveEnchants.remove(player.getUniqueId());
            this.removeEnchant(player);
            return true;
        }
        if (!alreadyOnList && isLiquid) {
            this.playerWithActiveEnchants.add(player.getUniqueId());
            this.addEnchant(player);
            return true;
        }
        return true;
    }

    @EventHandler
    public void playerOpenInventory(InventoryOpenEvent event) {
        HumanEntity player = event.getPlayer();
        if (!(player instanceof Player)) {
            return;
        }
        UUID id = player.getUniqueId();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(id);
        if (racPlayer == null) {
            return;
        }
        if (!racPlayer.getTraits().contains(this)) {
            return;
        }
        this.playerWithOpenedInventories.add(id);
        if (this.playerWithActiveEnchants.contains(id)) {
            this.removeEnchant(racPlayer);
            this.playerWithActiveEnchants.remove(id);
        }
    }

    @EventHandler
    public void playerCloseInventory(InventoryCloseEvent event) {
        HumanEntity player = event.getPlayer();
        if (!(player instanceof Player)) {
            return;
        }
        UUID id = player.getUniqueId();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(id);
        if (racPlayer == null) {
            return;
        }
        this.playerWithOpenedInventories.remove(id);
        this.playerWithActiveEnchants.remove(racPlayer.getUniqueId());
    }

    @EventHandler
    public void playerClickBoots(InventoryClickEvent event) {
        HumanEntity player = event.getWhoClicked();
        if (!(player instanceof Player)) {
            return;
        }
        UUID id = player.getUniqueId();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(id);
        if (racPlayer == null) {
            return;
        }
        if (!this.playerWithActiveEnchants.contains(id)) {
            return;
        }
        if (event.getView().getType() != InventoryType.PLAYER) {
            return;
        }
        if (event.getSlot() == 8 && event.getRawSlot() == 8) {
            event.setCancelled(true);
            InventoryResync.resync((Player)player);
        }
    }

    @EventHandler
    public void playerLeavesServer(PlayerQuitEvent event) {
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(event.getPlayer());
        if (this.playerWithActiveEnchants.contains(racPlayer.getUniqueId())) {
            this.removeEnchant(racPlayer);
        }
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "";
    }

    @Override
    public void deInit() {
        super.deInit();
        for (UUID active : this.playerWithActiveEnchants) {
            Player pl = Bukkit.getPlayer((UUID)active);
            if (pl == null) continue;
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(pl);
            this.removeEnchant(racPlayer);
        }
    }
}

