/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.SunDamageTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class SunDamageTrait
extends TickEverySecondsTrait {
    private double damage = 0.0;
    private boolean standing = true;
    private boolean canKill = false;

    @Override
    public String getName() {
        return "SunDamageTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class), @TraitConfigurationField(fieldName="standing", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="canKill", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        configMap.put("onlyOnDay", (Object)true);
        super.setConfiguration(configMap);
        this.damage = (Double)configMap.get("damage");
        if (configMap.containsKey("standing")) {
            this.standing = (Boolean)configMap.get("standing");
        }
        if (configMap.containsKey("canKill")) {
            this.canKill = (Boolean)configMap.get("canKill");
        }
        this.onlyOnDay = true;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait does damage when standing in the sun.");
        return helpList;
    }

    @Override
    @TraitInfos(category="passive", traitName="SunDamageTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        int highestLocation;
        if (!this.standing) {
            return true;
        }
        RaCPlayer player = wrapper.getPlayer();
        int playerYLocation = player.getLocation().getBlockY();
        return playerYLocation >= (highestLocation = player.getWorld().getHighestBlockYAt(player.getLocation()));
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        if (!this.canBeTriggered(EventWrapperFactory.buildOnlyWithplayer(player.getPlayer()))) {
            return false;
        }
        EntityDamageEvent damageEvent = CompatibilityModifier.EntityDamage.safeCreateEvent((Entity)player.getPlayer(), EntityDamageEvent.DamageCause.FIRE, this.damage);
        plugin.fireEventToBukkit((Event)damageEvent);
        if (damageEvent.isCancelled() || damageEvent.getDamage() <= 0.0) {
            return false;
        }
        double newValue = CompatibilityModifier.BukkitPlayer.safeGetHealth(player.getPlayer()) - damageEvent.getDamage();
        if (this.canKill || newValue >= 0.0) {
            CompatibilityModifier.BukkitPlayer.safeDamage(CompatibilityModifier.EntityDamage.safeGetDamage(damageEvent), player.getPlayer());
        }
        return true;
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "Damage: " + this.damage;
    }
}

