/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.StickDamageIncreaseTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class StickDamageIncreaseTrait
extends AbstractPassiveTrait {
    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "StickDamageIncreaseTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.operation) + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class), @TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = (String)configMap.get("operation");
        this.value = (Double)configMap.get("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        double newValue = this.getNewValue(eventWrapper.getPlayer(), Eevent.getDamage(), "value");
        CompatibilityModifier.EntityDamage.safeSetDamage(newValue, (EntityDamageEvent)Eevent);
        return TraitResults.True();
    }

    private boolean checkItemIsStick(ItemStack stack) {
        Material item = stack.getType();
        return item == Material.STICK;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof StickDamageIncreaseTrait)) {
            return false;
        }
        StickDamageIncreaseTrait otherTrait = (StickDamageIncreaseTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="StickDamageIncreaseTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait increases the Damage of your Sticks.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.DO_DAMAGE) {
            return false;
        }
        Player player = wrapper.getPlayer().getPlayer();
        return this.checkItemIsStick(player.getInventory().getItem(player.getInventory().getHeldItemSlot()));
    }
}

