/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.SpecificRegenerationTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.events.entitydamage.EntityHealEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class SpecificRegenerationTrait
extends TickEverySecondsTrait {
    private double heal = 0.0;
    private final DecimalFormat format = new DecimalFormat("0.#");

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        super.generalInit();
    }

    @Override
    public void deInit() {
        super.deInit();
    }

    @Override
    public String getName() {
        return "SpecificRegenerationTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="health", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.heal = configMap.getAsDouble("health");
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait heals when the Preconditions are correct.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof SpecificRegenerationTrait)) {
            return false;
        }
        SpecificRegenerationTrait otherTrait = (SpecificRegenerationTrait)trait;
        return this.heal >= otherTrait.heal;
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    @TraitInfos(category="passive", traitName="SpecificRegenerationTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        RaCPlayer player = wrapper.getPlayer();
        byte lightFromSky = player.getLocation().getBlock().getLightFromSky();
        return !this.onlyOnDay || lightFromSky <= 2;
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        double modHeal = this.modifyToPlayer(player, this.heal, "health");
        EntityHealEvent regainHealthEvent = CompatibilityModifier.EntityHeal.safeGenerate((Entity)player.getPlayer(), modHeal, EntityRegainHealthEvent.RegainReason.REGEN);
        Bukkit.getPluginManager().callEvent((Event)regainHealthEvent);
        if (!regainHealthEvent.isCancelled()) {
            double newHealValue = CompatibilityModifier.EntityRegainHealth.safeGetAmount(regainHealthEvent);
            CompatibilityModifier.BukkitPlayer.safeHeal(newHealValue, player.getPlayer());
        }
        return true;
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "Heals " + this.format.format(this.heal);
    }
}

