/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.RegularDamageTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class RegularDamageTrait
extends AbstractBasicTrait {
    private int schedulerTaskId = -1;
    private int seconds = 1;
    private double damage = 0.0;

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        this.schedulerTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                for (AbstractTraitHolder holder : RegularDamageTrait.this.getTraitHolders()) {
                    for (RaCPlayer player : holder.getHolderManager().getAllPlayersOfHolder(holder)) {
                        EventWrapper wrapper = EventWrapperFactory.buildOnlyWithplayer(player.getPlayer());
                        if (player == null || wrapper == null || RegularDamageTrait.this.checkRestrictions(wrapper) == TraitRestriction.None || !RegularDamageTrait.this.canBeTriggered(wrapper)) continue;
                        EntityDamageEvent damageEvent = CompatibilityModifier.EntityDamage.safeCreateEvent((Entity)player.getPlayer(), EntityDamageEvent.DamageCause.MAGIC, RegularDamageTrait.this.damage);
                        Bukkit.getPluginManager().callEvent((Event)damageEvent);
                        if (!damageEvent.isCancelled()) {
                            player.getPlayer().damage(CompatibilityModifier.EntityDamage.safeGetDamage(damageEvent));
                        }
                        plugin.getStatistics().traitTriggered(RegularDamageTrait.this);
                    }
                }
            }
        }, (long)(this.seconds * 20), (long)(this.seconds * 20));
    }

    @Override
    public void deInit() {
        Bukkit.getScheduler().cancelTask(this.schedulerTaskId);
    }

    @Override
    public String getName() {
        return "RegularDamageTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        String reason = "Nothing";
        if (this.onlyInLava) {
            reason = "in Lava";
        }
        if (this.onlyInWater) {
            reason = "in Water";
        }
        if (this.onlyOnLand) {
            reason = "on Land";
        }
        if (this.onlyOnDay && !this.onlyInNight) {
            reason = "in NightShine";
        }
        if (this.onlyInNight && !this.onlyOnDay) {
            reason = "on DayLight";
        }
        return "Damage: " + this.damage + " every: " + this.seconds + " sec for " + reason;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="seconds", classToExpect=Integer.class), @TraitConfigurationField(fieldName="damage", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.seconds = (Integer)configMap.get("seconds");
        this.damage = (Double)configMap.get("damage");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait does damage when the Preconditions are correct.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof RegularDamageTrait)) {
            return false;
        }
        RegularDamageTrait otherTrait = (RegularDamageTrait)trait;
        return this.damage >= otherTrait.damage;
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    @TraitInfos(category="passive", traitName="RegularDamageTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        byte lightFromSky = wrapper.getPlayer().getLocation().getBlock().getLightFromSky();
        return !this.onlyOnDay || lightFromSky <= 2;
    }
}

