/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.RegenerationTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class RegenerationTrait
extends AbstractPassiveTrait {
    @Override
    @TraitEventsUsed(registerdClasses={EntityRegainHealthEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "RegenerationTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "regeneration: " + this.operation + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="value", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = configMap.getAsString("operation", "+");
        this.value = configMap.getAsDouble("value", 1.0);
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        EntityRegainHealthEvent Eevent = (EntityRegainHealthEvent)event;
        double oldValue = CompatibilityModifier.EntityRegainHealth.safeGetAmount(Eevent);
        double newValue = this.getNewValue(eventWrapper.getPlayer(), oldValue, "value");
        CompatibilityModifier.EntityRegainHealth.safeSetAmount(Eevent, newValue);
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait increases the life regeneration of a Player.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof RegenerationTrait)) {
            return false;
        }
        RegenerationTrait otherTrait = (RegenerationTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="RegenerationTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getRegainResource() != EventWrapper.RegainResource.HEALTH) {
            return false;
        }
        return wrapper.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED;
    }
}

