/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.PermissionTrait;

import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassSelectedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceSelectedEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.RemoveSuperConfigField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.permissions.PermissionManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PermissionTrait
extends TickEverySecondsTrait
implements Listener {
    private final List<String> permissions = new LinkedList<String>();
    private final List<RaCPlayer> playersWithPerms = new LinkedList<RaCPlayer>();

    @Override
    public String getName() {
        return "PermissionTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="permissions", classToExpect=List.class, optional=true), @TraitConfigurationField(fieldName="permission", classToExpect=String.class, optional=true)}, removedFields={@RemoveSuperConfigField(name="seconds")})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        configMap.put("seconds", (Object)1);
        super.setConfiguration(configMap);
        if (configMap.containsKey("permission")) {
            this.permissions.add(configMap.getAsString("permission"));
        }
        if (configMap.containsKey("permissions")) {
            this.permissions.addAll(configMap.getAsStringList("permissions"));
        }
        if (!this.permissions.isEmpty()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait Sets a permission.");
        return helpList;
    }

    @Override
    @TraitInfos(category="passive", traitName="PermissionTrait", visible=true)
    public void importTrait() {
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        this.checkPerms(player, true);
        return false;
    }

    @Override
    protected void restrictionsFailed(RaCPlayer player) {
        this.checkPerms(player, false);
    }

    @EventHandler
    public void playerLogout(PlayerQuitEvent event) {
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        this.checkPerms(player, false);
    }

    @EventHandler
    public void playerLeaveHolder(AfterClassSelectedEvent event) {
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        this.checkPerms(player, false);
    }

    @EventHandler
    public void playerLeaveHolder(AfterRaceSelectedEvent event) {
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        this.checkPerms(player, false);
    }

    @Override
    public void deInit() {
        super.deInit();
        for (RaCPlayer player : new HashSet<RaCPlayer>(this.playersWithPerms)) {
            if (!player.isOnline()) continue;
            this.checkPerms(player, false);
        }
    }

    protected void checkPerms(RaCPlayer player, boolean add) {
        block4: {
            block3: {
                if (!add) break block3;
                if (this.playersWithPerms.contains(player)) break block4;
                this.playersWithPerms.add(player);
                for (String perm : this.permissions) {
                    PermissionManager permManager = plugin.getPermissionManager();
                    permManager.addPermission((OfflinePlayer)player.getPlayer(), perm);
                }
                break block4;
            }
            if (this.playersWithPerms.contains(player)) {
                this.playersWithPerms.remove(player);
                for (String perm : this.permissions) {
                    PermissionManager permManager = plugin.getPermissionManager();
                    permManager.removePermission((OfflinePlayer)player.getPlayer(), perm);
                }
            }
        }
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "";
    }

    @Override
    protected String getPrettyConfigIntern() {
        String perms = "";
        Iterator<String> it = this.permissions.iterator();
        while (it.hasNext()) {
            perms = String.valueOf(perms) + it.next();
            if (!it.hasNext()) continue;
            perms = String.valueOf(perms) + ",";
        }
        return "permission: " + perms;
    }

    @Override
    public boolean isStackable() {
        return true;
    }
}

