/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.PermanentPotionTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.RemoveSuperConfigField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitJoinLeave;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PermanentPotionTrait
extends TickEverySecondsTrait
implements TraitJoinLeave {
    private int amplifier = 0;
    private PotionEffectType type;
    private boolean removeParticles = false;
    private BukkitTask particleTask = null;

    @Override
    public String getName() {
        return "PermanentPotionTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="type", classToExpect=Integer.class, optional=false), @TraitConfigurationField(fieldName="amplifier", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="removeParticles", classToExpect=Boolean.class, optional=true)}, removedFields={@RemoveSuperConfigField(name="seconds")})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        if (!configMap.containsKey("seconds")) {
            configMap.put("seconds", (Object)5);
        }
        super.setConfiguration(configMap);
        this.amplifier = configMap.getAsInt("amplifier", 1);
        this.type = PotionEffectType.getById((int)configMap.getAsInt("type", 0));
        this.removeParticles = configMap.getAsBool("removeParticles", false);
        if (this.type == null) {
            throw new TraitConfigurationFailedException("unknown Potion effect.");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait aplies a potion effect permanently to the player.");
        return helpList;
    }

    @Override
    @TraitInfos(category="passive", traitName="PermanentPotionTrait", visible=true)
    public void importTrait() {
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        boolean replace = true;
        for (PotionEffect effect : player.getPlayer().getActivePotionEffects()) {
            if (effect.getType() != this.type || effect.getAmplifier() <= this.amplifier) continue;
            replace = false;
            break;
        }
        if (replace) {
            int modAmp = this.modifyToPlayer(player, this.amplifier, "amplifier");
            PotionEffect newPotionEffect = new PotionEffect(this.type, 720000, modAmp);
            player.getPlayer().addPotionEffect(newPotionEffect, true);
            if (this.removeParticles) {
                Vollotile.get().removeParticleEffect((LivingEntity)player.getPlayer());
            }
        }
        if (this.removeParticles && this.particleTask == null) {
            this.particleTask = new BukkitRunnable(){

                public void run() {
                    for (AbstractTraitHolder holder : PermanentPotionTrait.this.getTraitHolders()) {
                        for (RaCPlayer player : holder.getHolderManager().getAllPlayersOfHolder(holder)) {
                            if (player == null || !player.isOnline()) continue;
                            Vollotile.get().removeParticleEffect((LivingEntity)player.getPlayer());
                        }
                    }
                }
            }.runTaskTimer((Plugin)plugin, 10L, 10L);
        }
        return true;
    }

    @Override
    protected void restrictionsFailed(RaCPlayer racPlayer) {
        super.restrictionsFailed(racPlayer);
        Player player = racPlayer.getPlayer();
        player.removePotionEffect(this.type);
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "potion: " + this.type.getName() + " amplifier: " + this.amplifier;
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    public void playerJoines(RaCPlayer racPlayer) {
    }

    @Override
    public void playerLeaves(RaCPlayer racPlayer) {
        Player player = racPlayer.getPlayer();
        if (player != null) {
            player.removePotionEffect(this.type);
        }
    }
}

