/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.PermanentEnchantTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.events.inventoryitemevents.PlayerDisequipsArmorEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.inventoryitemevents.PlayerEquipsArmorEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.items.ItemUtils;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;

public class PermanentEnchantTrait
extends AbstractBasicTrait {
    private int amplifier = 1;
    private Enchantment type;
    private ItemUtils.ArmorSlot armorSlot;
    private Set<UUID> containing = new HashSet<UUID>();

    @Override
    public String getName() {
        return "PermanentEnchantTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="amplifier", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="type", classToExpect=Integer.class, optional=false), @TraitConfigurationField(fieldName="slot", classToExpect=String.class, optional=false)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        configMap.put("seconds", (Object)5);
        super.setConfiguration(configMap);
        if (configMap.containsKey("amplifier")) {
            this.amplifier = configMap.getAsInt("amplifier");
        }
        this.type = Enchantment.getByName((String)configMap.getAsString("type"));
        if (configMap.containsKey("slot")) {
            this.armorSlot = ItemUtils.ArmorSlot.valueOf(configMap.getAsString("slot").toUpperCase());
        }
        if (this.type == null) {
            throw new TraitConfigurationFailedException("unknown Enchantment effect.");
        }
        if (this.armorSlot == null) {
            throw new TraitConfigurationFailedException("unknown armor Slot.");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait aplies an enchantment effect permanently to the player.");
        return helpList;
    }

    @Override
    @TraitInfos(category="passive", traitName="PermanentEnchantTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    public void generalInit() {
    }

    @Override
    public TraitResults trigger(EventWrapper wrapper) {
        return TraitResults.False();
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return false;
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Applies " + Enchantment.ARROW_FIRE.getName() + "-" + this.amplifier + " to " + this.armorSlot.name();
    }

    @EventHandler
    public void onPlayerEquipItem(PlayerEquipsArmorEvent event) {
        Player eventPlayer = event.getPlayer();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(eventPlayer);
        if (eventPlayer == null || racPlayer == null) {
            return;
        }
        if (TraitHolderCombinder.checkContainer(racPlayer, this)) {
            ItemStack item = ItemUtils.getItemInArmorSlotOfPlayer(eventPlayer, this.armorSlot);
            if (item == null) {
                return;
            }
            int amp = item.getEnchantmentLevel(this.type);
            if (amp > 0) {
                return;
            }
            item.addUnsafeEnchantment(this.type, this.amplifier);
            this.containing.add(racPlayer.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerDisequipArmor(PlayerDisequipsArmorEvent event) {
        Player eventPlayer = event.getPlayer();
        if (!this.containing.contains(eventPlayer.getUniqueId())) {
            return;
        }
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(eventPlayer);
        if (eventPlayer == null || racPlayer == null) {
            return;
        }
        if (TraitHolderCombinder.checkContainer(racPlayer, this)) {
            ItemStack item = ItemUtils.getItemInArmorSlotOfPlayer(eventPlayer, this.armorSlot);
            item.removeEnchantment(this.type);
            this.containing.remove(eventPlayer.getUniqueId());
        }
    }
}

