/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.PassiveAggroTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;

public class PassiveAggroTrait
extends AbstractBasicTrait {
    private final Map<EntityType, Integer> aggroDistanceList = new HashMap<EntityType, Integer>();

    @Override
    public String getName() {
        return "PassiveAggroTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="aggro", classToExpect=List.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.aggroDistanceList.clear();
        if (configMap.containsKey("aggro")) {
            List<String> list = configMap.getAsStringList("aggro");
            for (String entry : list) {
                String[] split;
                if (!entry.contains("#") || (split = entry.split("#")).length != 2) continue;
                EntityType type = null;
                EntityType[] entityTypeArray = EntityType.values();
                int n = entityTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EntityType tmp = entityTypeArray[n2];
                    if (tmp.name().equalsIgnoreCase(split[0])) {
                        type = tmp;
                    }
                    ++n2;
                }
                if (type == null) {
                    type = EntityType.fromName((String)split[0].replace("_", "").replace(" ", ""));
                }
                if (type == null) continue;
                int range = 20;
                try {
                    range = Integer.parseInt(split[1]);
                }
                catch (Throwable exp) {
                    continue;
                }
                this.aggroDistanceList.put(type, range);
            }
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait Changes the Aggro Distance.");
        return helpList;
    }

    @Override
    @TraitInfos(category="passive", traitName="PassiveAggroTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public void deInit() {
        super.deInit();
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onAggroChange(EntityTargetEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.aggroDistanceList.isEmpty()) {
            return;
        }
        if (event.getTarget() == null) {
            return;
        }
        if (event.getTarget().getType() != EntityType.PLAYER) {
            return;
        }
        EntityType monster = event.getEntityType();
        if (!this.aggroDistanceList.containsKey(monster)) {
            return;
        }
        Player player = (Player)event.getTarget();
        if (super.checkRestrictions(EventWrapperFactory.buildOnlyWithplayer(player)) != TraitRestriction.None) {
            return;
        }
        int maxDist = this.aggroDistanceList.get(monster);
        if (player.getLocation().distanceSquared(event.getTarget().getLocation()) > (double)(maxDist * maxDist)) {
            event.setCancelled(true);
        }
    }

    @Override
    protected String getPrettyConfigIntern() {
        String val = "";
        for (Map.Entry<EntityType, Integer> entry : this.aggroDistanceList.entrySet()) {
            val = String.valueOf(val) + ", " + entry.getKey().name() + ": " + entry.getValue();
        }
        return "MonsterRanges: " + (val.isEmpty() ? val : val.substring(2));
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    public void generalInit() {
    }

    @Override
    public TraitResults trigger(EventWrapper wrapper) {
        return TraitResults.False();
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return false;
    }
}

