/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.NoHungerTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class NoHungerTrait
extends AbstractBasicTrait {
    private boolean alwaysFill = false;
    private BukkitTask refiller;

    @Override
    public String getName() {
        return "NoHungerTrait";
    }

    @Override
    @TraitInfos(category="passive", traitName="NoHungerTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(classToExpect=Boolean.class, fieldName="alwaysFill", optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("alwaysFill")) {
            this.alwaysFill = configMap.getAsBool("alwaysFill");
            if (this.alwaysFill) {
                if (this.refiller != null) {
                    this.refiller.cancel();
                }
                this.refiller = new Refiller().runTaskTimer((Plugin)plugin, 20L, 20L);
            }
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait removes Hunger.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper arg0) {
        return false;
    }

    @Override
    public void generalInit() {
        plugin.registerEvents(this);
    }

    @Override
    public boolean isBetterThan(Trait arg) {
        return false;
    }

    @Override
    public TraitResults trigger(EventWrapper arg) {
        return TraitResults.False();
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "no hunger";
    }

    @EventHandler
    public void removeHungerReduce(FoodLevelChangeEvent event) {
        RaCPlayer racPlayer;
        HumanEntity humanEntity = event.getEntity();
        if (humanEntity instanceof Player && (racPlayer = RaCPlayerManager.get().getPlayer(humanEntity.getUniqueId())) != null && TraitHolderCombinder.checkContainer(racPlayer, this)) {
            event.setCancelled(true);
            racPlayer.getPlayer().setFoodLevel(20);
        }
    }

    private class Refiller
    extends DebugBukkitRunnable {
        public Refiller() {
            super("HungerRefiller");
        }

        @Override
        public void runIntern() {
            for (AbstractTraitHolder holder : NoHungerTrait.this.getTraitHolders()) {
                for (RaCPlayer player : holder.getHolderManager().getAllPlayersOfHolder(holder)) {
                    try {
                        player.getPlayer().setFoodLevel(20);
                        player.getPlayer().setSaturation(20.0f);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

