/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.NightDamageTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class NightDamageTrait
extends TickEverySecondsTrait {
    private double damage = 0.0;
    private boolean standing = true;

    @Override
    public String getName() {
        return "NightDamageTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class), @TraitConfigurationField(fieldName="standing", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.damage = (Double)configMap.get("damage");
        if (configMap.containsKey("standing")) {
            this.standing = (Boolean)configMap.get("standing");
        }
        this.onlyInNight = true;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait does damage when standing in the moon light.");
        return helpList;
    }

    @Override
    @TraitInfos(category="passive", traitName="NightDamageTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (this.standing) {
            return true;
        }
        RaCPlayer player = wrapper.getPlayer();
        int playerYLocation = player.getLocation().getBlockY();
        int highestLocation = player.getWorld().getHighestBlockYAt(player.getLocation());
        return highestLocation >= playerYLocation;
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        EntityDamageEvent damageEvent = CompatibilityModifier.EntityDamage.safeCreateEvent((Entity)player.getPlayer(), EntityDamageEvent.DamageCause.FIRE, this.damage);
        plugin.fireEventToBukkit((Event)damageEvent);
        if (!damageEvent.isCancelled()) {
            return false;
        }
        player.getPlayer().damage(CompatibilityModifier.EntityDamage.safeGetDamage(damageEvent));
        return true;
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "Damage: " + this.damage;
    }
}

