/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.MovementSpeedTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.HolderSelectedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassChangedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceChangedEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.RemoveSuperConfigField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.math.Math2;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MovementSpeedTrait
extends TickEverySecondsTrait {
    private double value;
    private final float DEFAULT_SPEED = 0.2f;

    @Override
    @TraitEventsUsed(registerdClasses={AfterClassChangedEvent.class, AfterRaceChangedEvent.class})
    public void generalInit() {
        super.generalInit();
    }

    @Override
    public String getName() {
        return "MovementSpeedTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "speed: " + this.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="MovementSpeedTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (trait instanceof MovementSpeedTrait) {
            return this.value > ((MovementSpeedTrait)trait).value;
        }
        return false;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        HolderSelectedEvent classEvent;
        Event event = wrapper.getEvent();
        if (event == null && wrapper.getPlayer() != null) {
            return true;
        }
        if (event instanceof AfterClassChangedEvent && this.holders.contains(((AfterClassChangedEvent)(classEvent = (AfterClassChangedEvent)event)).getOldClass())) {
            this.setNewSpeed(RaCPlayerManager.get().getPlayer(classEvent.getPlayer()), 0.2f);
        }
        if (event instanceof AfterRaceChangedEvent && this.holders.contains(((AfterRaceChangedEvent)(classEvent = (AfterRaceChangedEvent)event)).getOldRace())) {
            this.setNewSpeed(RaCPlayerManager.get().getPlayer(classEvent.getPlayer()), 0.2f);
        }
        return false;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class)}, removedFields={@RemoveSuperConfigField(name="seconds")})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        if (!configMap.containsKey("seconds")) {
            configMap.put("seconds", (Object)5);
        }
        super.setConfiguration(configMap);
        this.value = (Double)configMap.get("value");
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait changes (increases or decreases) the movement speed of a Player.");
        return helpList;
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        boolean isOnDisabledWorld = this.checkDisabledPerWorld(player.getWorld());
        float convertedValue = isOnDisabledWorld ? 0.2f : (float)this.modifyToPlayer(player, this.value, "value");
        this.setNewSpeed(player, convertedValue);
        return false;
    }

    @Override
    protected void restrictionsFailed(RaCPlayer player) {
        this.setNewSpeed(player, 0.2f);
    }

    private void setNewSpeed(final RaCPlayer player, float convertedValue) {
        final float clampedValue = Math2.clamp(-1.0f, convertedValue, 1.0f);
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                Player pl = player.getPlayer();
                float currentSpeed = pl.getWalkSpeed();
                if ((double)Math.abs(currentSpeed - clampedValue) > 0.02) {
                    player.getPlayer().setWalkSpeed(clampedValue);
                }
            }
        }.runTaskLater((Plugin)plugin, 2L);
    }

    private boolean checkDisabledPerWorld(World world) {
        List<String> worldsDisabledOn = plugin.getConfigManager().getGeneralConfig().getConfig_worldsDisabled();
        String worldName = world == null ? "" : world.getName();
        for (String disabledWorldName : worldsDisabledOn) {
            if (!disabledWorldName.equalsIgnoreCase(worldName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "";
    }
}

