/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.MonsterDropItemTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.collections.CollectionUtils;
import de.tobiyas.util.RaC.items.ItemMetaUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MonsterDropItemTrait
extends AbstractBasicTrait {
    private ItemStack item;
    private String neededName = "";
    private final Map<EntityType, Double> dropChances = new HashMap<EntityType, Double>();

    @Override
    public String getName() {
        return "MonsterDropItemTrait";
    }

    @Override
    @TraitInfos(category="passive", traitName="MonsterDropItemTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(classToExpect=List.class, fieldName="drops", optional=false), @TraitConfigurationField(classToExpect=String.class, fieldName="monstername", optional=false), @TraitConfigurationField(classToExpect=Material.class, fieldName="material", optional=false), @TraitConfigurationField(classToExpect=Integer.class, fieldName="damage", optional=true), @TraitConfigurationField(classToExpect=String.class, fieldName="name", optional=true), @TraitConfigurationField(classToExpect=List.class, fieldName="lore", optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        Material mat = configMap.getAsMaterial("material", Material.STONE);
        this.item = new ItemStack(mat);
        if (configMap.containsKey("damage")) {
            this.item.setDurability((short)configMap.getAsInt("damage", 0));
        }
        if (configMap.containsKey("name")) {
            String itemName = ChatColor.translateAlternateColorCodes((char)'&', (String)configMap.getAsString("name"));
            ItemMetaUtils.setDisplayNameOfItem(this.item, itemName);
        }
        if (configMap.containsKey("lore")) {
            List<String> lore = CollectionUtils.translateChatColors(configMap.getAsStringList("lore"));
            ItemMeta meta = this.item.getItemMeta();
            meta.setLore(lore);
            this.item.setItemMeta(meta);
        }
        if (configMap.containsKey("drops")) {
            List<String> drops = configMap.getAsStringList("drops");
            this.dropChances.clear();
            this.dropChances.putAll(MonsterDropItemTrait.convertToDropMap(drops));
        }
        if (configMap.containsKey("monstername")) {
            this.neededName = configMap.getAsString("monstername", "");
        }
    }

    private static Map<EntityType, Double> convertToDropMap(List<String> toParse) {
        HashMap<EntityType, Double> parsed = new HashMap<EntityType, Double>();
        for (String line : toParse) {
            String[] split = line.split(Pattern.quote(";"));
            if (split.length != 2) continue;
            try {
                EntityType type = EntityType.valueOf((String)split[0].replace(" ", "_").toUpperCase());
                double percent = Double.parseDouble(split[1]);
                parsed.put(type, percent);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return parsed;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait drops stuff at the kill of monsters.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper arg0) {
        return false;
    }

    @Override
    public void generalInit() {
        plugin.registerEvents(this);
    }

    @Override
    public boolean isBetterThan(Trait arg) {
        return false;
    }

    @Override
    public TraitResults trigger(EventWrapper arg) {
        return TraitResults.False();
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Drops an item when killing monsters.";
    }

    private ItemStack playerKilled(EntityType type) {
        if (!this.dropChances.containsKey(type)) {
            return null;
        }
        double percent = this.dropChances.get(type);
        if (Math.random() * 100.0 > percent) {
            return null;
        }
        return this.item.clone();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void monsterDied(EntityDeathEvent event) {
        boolean canBeTriggered;
        String monsterName;
        if (this.item == null) {
            return;
        }
        LivingEntity died = event.getEntity();
        if (died == null) {
            return;
        }
        Player killer = died.getKiller();
        if (killer == null) {
            return;
        }
        RaCPlayer racKiller = RaCPlayerManager.get().getPlayer(killer);
        if (racKiller == null) {
            return;
        }
        if (!this.neededName.isEmpty() && !this.neededName.equalsIgnoreCase(monsterName = ChatColor.stripColor((String)died.getCustomName()))) {
            return;
        }
        if (!TraitHolderCombinder.checkContainer(racKiller, this)) {
            return;
        }
        EventWrapper wrapper = EventWrapperFactory.buildOnlyWithplayer(racKiller);
        boolean bl = canBeTriggered = super.checkRestrictions(wrapper) == TraitRestriction.None;
        if (!canBeTriggered) {
            return;
        }
        ItemStack drop = this.playerKilled(died.getType());
        event.getDrops().add(drop);
    }
}

