/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.MiningSpeedTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MiningSpeedTrait
extends AbstractPassiveTrait {
    private List<Material> blocksToVerify = new LinkedList<Material>();
    private PotionEffect effect = null;

    @Override
    @TraitEventsUsed(registerdClasses={BlockDamageEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "MiningSpeedTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        String blocksString = "";
        for (Material mat : this.blocksToVerify) {
            blocksString = String.valueOf(blocksString) + " " + mat.name();
        }
        return "MiningSpeed: " + this.effect.getAmplifier() + " blocks: " + blocksString;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Integer.class), @TraitConfigurationField(fieldName="blocks", classToExpect=List.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        int value = (Integer)configMap.get("value");
        if (value == 0 || value > 5 || value < -5) {
            throw new TraitConfigurationFailedException("value: " + value + " is not aplyable. " + "It has to be between -5 and 5 (without 0)");
        }
        this.effect = this.calcPotionEffectFromValue(value);
        this.blocksToVerify.clear();
        List blockList = (List)configMap.get("blocks");
        if (blockList == null || blockList.isEmpty()) {
            Material[] materialArray = Material.values();
            int n = materialArray.length;
            int n2 = 0;
            while (n2 < n) {
                Material mat = materialArray[n2];
                if (mat.isBlock()) {
                    this.blocksToVerify.add(mat);
                }
                ++n2;
            }
        } else {
            for (String block : blockList) {
                Material material = Material.valueOf((String)block.toUpperCase());
                if (material == null) continue;
                this.blocksToVerify.add(material);
            }
        }
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        BlockDamageEvent Eevent = (BlockDamageEvent)event;
        Player player = Eevent.getPlayer();
        boolean isValidBlock = this.blocksToVerify.contains(Eevent.getBlock().getType());
        if (isValidBlock) {
            player.addPotionEffect(this.effect, true);
        } else {
            player.removePotionEffect(this.effect.getType());
        }
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Your Mining speed gets changed for specific blocks.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof MiningSpeedTrait)) {
            return false;
        }
        MiningSpeedTrait otherTrait = (MiningSpeedTrait)trait;
        return this.effect.getAmplifier() >= otherTrait.effect.getAmplifier();
    }

    @Override
    @TraitInfos(category="passive", traitName="MiningSpeedTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (!(event instanceof BlockDamageEvent)) {
            return false;
        }
        BlockDamageEvent Eevent = (BlockDamageEvent)event;
        Player player = Eevent.getPlayer();
        Block block = Eevent.getBlock();
        if (this.blocksToVerify.contains(block.getType())) {
            return true;
        }
        return player.hasPotionEffect(this.effect.getType());
    }

    private PotionEffect calcPotionEffectFromValue(int value) {
        if (value > 0) {
            return new PotionEffect(PotionEffectType.FAST_DIGGING, 10, value, false);
        }
        return new PotionEffect(PotionEffectType.SLOW_DIGGING, 10, -value, false);
    }
}

