/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.MaxHealthBoostTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassChangedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassSelectedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceChangedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceSelectedEvent;
import de.tobiyas.racesandclasses.playermanagement.health.HealthManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.RemoveSuperConfigField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerQuitEvent;

public class MaxHealthBoostTrait
extends TickEverySecondsTrait {
    private double healthAmount;
    private final String boostID = UUID.randomUUID().toString();

    @Override
    @TraitInfos(category="passive", traitName="MaxHealthBoostTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitEventsUsed
    public void generalInit() {
        super.generalInit();
        plugin.registerEvents(this);
    }

    @Override
    public String getName() {
        return "MaxHealthBoostTrait";
    }

    @Override
    public TraitResults trigger(EventWrapper wrapper) {
        return TraitResults.True();
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="amount", classToExpect=Double.class)}, removedFields={@RemoveSuperConfigField(name="seconds")})
    public void setConfiguration(TraitConfiguration config) throws TraitConfigurationFailedException {
        if (!config.containsKey("seconds")) {
            config.put("seconds", (Object)3);
        }
        super.setConfiguration(config);
        this.healthAmount = config.getAsDouble("amount", 0.0);
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (trait instanceof MaxHealthBoostTrait) {
            return this.healthAmount > ((MaxHealthBoostTrait)trait).healthAmount;
        }
        return false;
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Add " + this.healthAmount + " Health";
    }

    @EventHandler
    public void playerLogout(PlayerQuitEvent event) {
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        this.checkHealthBoost(player);
    }

    @EventHandler
    public void playerChangeHolder(AfterClassSelectedEvent event) {
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        this.checkHealthBoost(player);
    }

    @EventHandler
    public void playerChangeHolder(AfterRaceSelectedEvent event) {
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        this.checkHealthBoost(player);
    }

    @EventHandler
    public void playerChangeHolder(AfterClassChangedEvent event) {
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        this.checkHealthBoost(player);
    }

    @EventHandler
    public void playerChangeHolder(AfterRaceChangedEvent event) {
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        this.checkHealthBoost(player);
    }

    @Override
    public void skillLevelChanged(RaCPlayer player) {
        super.skillLevelChanged(player);
        this.checkHealthBoost(player);
    }

    private void checkHealthBoost(RaCPlayer player) {
        boolean isInTrait = player.getTraits().contains(this);
        if (!isInTrait) {
            this.removeBoost(player);
            return;
        }
        if (this.restrictionsMet(player)) {
            this.addOrUpdateBoost(player);
        } else {
            this.removeBoost(player);
        }
    }

    private boolean restrictionsMet(RaCPlayer player) {
        return this.checkRestrictions(EventWrapperFactory.buildOnlyWithplayer(player)) == TraitRestriction.None;
    }

    private void removeBoost(RaCPlayer player) {
        HealthManager hm = player.getHealthManager();
        hm.removeMaxHealthBonus(this.boostID);
    }

    private void addOrUpdateBoost(RaCPlayer player) {
        double shouldBe = this.getModValue(player, "amount", this.healthAmount);
        HealthManager hm = player.getHealthManager();
        if (Math.abs(hm.getHealthBoostByName(this.boostID) - shouldBe) > 0.01) {
            hm.addMaxHealthBonus(this.boostID, shouldBe);
        }
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        this.addOrUpdateBoost(player);
        return true;
    }

    @Override
    protected void restrictionsFailed(RaCPlayer player) {
        super.restrictionsFailed(player);
        this.removeBoost(player);
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "Add " + this.healthAmount + " Max-Health";
    }
}

