/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.ManaRegenerationTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.events.mana.ManaRegenerationEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ManaRegenerationTrait
extends AbstractBasicTrait {
    private int bukkitTaskID = -1;
    private int time;
    private double value;

    @Override
    @TraitEventsUsed(registerdClasses={ManaRegenerationEvent.class})
    public void generalInit() {
        if (this.time > 0) {
            this.setupBukkitManaRegenerationTask();
        }
    }

    private void setupBukkitManaRegenerationTask() {
        if (this.time <= 0) {
            return;
        }
        if (this.bukkitTaskID > 0) {
            Bukkit.getScheduler().cancelTask(this.bukkitTaskID);
        }
        if (this.bukkitTaskID < 0 || !Bukkit.getScheduler().isQueued(this.bukkitTaskID)) {
            int tickTime = this.time * 20;
            this.bukkitTaskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    for (AbstractTraitHolder holder : ManaRegenerationTrait.this.getTraitHolders()) {
                        for (RaCPlayer player : holder.getHolderManager().getAllPlayersOfHolder(holder)) {
                            if (player == null || !player.isOnline()) continue;
                            double modValue = ManaRegenerationTrait.this.modifyToPlayer(player, ManaRegenerationTrait.this.value, "value");
                            Bukkit.getPluginManager().callEvent((Event)new ManaRegenerationEvent(player.getPlayer(), modValue));
                        }
                    }
                }
            }, (long)tickTime, (long)tickTime);
        }
    }

    @Override
    public String getName() {
        return "ManaRegenerationTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "value: " + this.value + "every " + this.time + " seconds";
    }

    @Override
    @TraitInfos(category="passive", traitName="ManaRegenerationTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (trait instanceof ManaRegenerationTrait) {
            return this.value > ((ManaRegenerationTrait)trait).value;
        }
        return false;
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        ManaRegenerationEvent manaRegEvent = (ManaRegenerationEvent)event;
        Player player = manaRegEvent.getPlayer();
        double amount = manaRegEvent.getAmount();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        racPlayer.getManaManager().fillMana(amount);
        return TraitResults.True();
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class), @TraitConfigurationField(fieldName="time", classToExpect=Integer.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = (Double)configMap.get("value");
        this.time = (Integer)configMap.get("time");
        this.setupBukkitManaRegenerationTask();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait changes (increases or decreases) the movement speed of a Player.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        EventWrapper.RegainResource resource = wrapper.getRegainResource();
        if (resource != EventWrapper.RegainResource.MANA) {
            return false;
        }
        RaCPlayer player = wrapper.getPlayer();
        return player != null && player.isOnline() && !player.getManaManager().isManaFull();
    }
}

