/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.ManaOnHitTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractWeaponDamageIncreaseTrait;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.event.Cancellable;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class ManaOnHitTrait
extends AbstractWeaponDamageIncreaseTrait {
    protected double chance = 0.1;

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.operation) + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = configMap.getAsDouble("value", 0.0);
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        RaCPlayer player = eventWrapper.getPlayer();
        double value = this.modifyToPlayer(player, this.value, "value");
        player.getManaManager().fillMana(value);
        player.sendTranslatedMessage("trait_mana_refill", "value", String.valueOf((int)value));
        return TraitResults.True();
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Regenerates mana on hits sometimes.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.DO_DAMAGE) {
            return false;
        }
        if (wrapper.getEvent() instanceof Cancellable && ((Cancellable)wrapper.getEvent()).isCancelled()) {
            return false;
        }
        if (wrapper.getEvent() instanceof EnemyChecker.FriendDetectEvent) {
            return false;
        }
        if (wrapper.getPlayer().getManaManager().isManaFull()) {
            return false;
        }
        double chance = this.modifyToPlayer(wrapper.getPlayer(), this.chance, "chance");
        return Math.random() <= chance;
    }

    @Override
    @TraitInfos(category="passive", traitName="ManaOnHitTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public String getName() {
        return "ManaOnHitTrait";
    }
}

