/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.LastStandTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.configuration.traits.TraitConfig;
import de.tobiyas.racesandclasses.eventprocessing.TraitEventManager;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.events.entitydamage.EntityHealEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class LastStandTrait
extends AbstractPassiveTrait {
    private static double activationLimit = 30.0;
    private double value = 5.0;
    private final DecimalFormat format = new DecimalFormat("0.0");

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageEvent.class}, traitPriority=1)
    public void generalInit() {
        TraitConfig config = plugin.getConfigManager().getTraitConfigManager().getConfigOfTrait(this.getName());
        if (config != null) {
            activationLimit = config.getDouble("trait.activationLimit", 30.0);
        }
    }

    @Override
    public String getName() {
        return "LastStandTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return " uplink-Time: " + this.cooldownTime + " secs, heals: " + this.format.format(this.value);
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="activationLimit", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("value")) {
            this.value = configMap.getAsDouble("value");
        }
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        double maxHealth;
        Event event = eventWrapper.getEvent();
        EntityDamageEvent Eevent = (EntityDamageEvent)event;
        Entity entity = Eevent.getEntity();
        Player player = (Player)entity;
        RaCPlayer racPlayer = eventWrapper.getPlayer();
        double health = racPlayer.getHealth() - Eevent.getDamage();
        double percent = 100.0 * health / (maxHealth = racPlayer.getMaxHealth());
        if (percent <= activationLimit) {
            double modValue = this.modifyToPlayer(racPlayer, this.value, "value");
            EntityHealEvent ehEvent = new EntityHealEvent((Entity)player, modValue, EntityRegainHealthEvent.RegainReason.MAGIC);
            TraitEventManager.fireEvent((Event)ehEvent);
            double amount = CompatibilityModifier.EntityHeal.safeGetAmount(ehEvent);
            if (!ehEvent.isCancelled() && amount > 0.0) {
                double healthBefore = CompatibilityModifier.BukkitPlayer.safeGetHealth(player);
                double newHealth = healthBefore + amount;
                if (newHealth > maxHealth) {
                    newHealth = maxHealth;
                    amount = newHealth - healthBefore;
                }
                CompatibilityModifier.BukkitPlayer.safeSetHealth(newHealth, player);
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "trait_laststand_success", "name", this.getDisplayName(), "value", this.format.format(amount));
                Location loc = player.getLocation();
                player.getWorld().playEffect(loc, Effect.POTION_BREAK, 1);
                return TraitResults.True();
            }
        }
        return TraitResults.False();
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof LastStandTrait)) {
            return false;
        }
        LastStandTrait otherTrait = (LastStandTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="LastStandTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait heals you if you drop below " + activationLimit + "% health.");
        helpList.add(ChatColor.YELLOW + "This can only happen every X seconds.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        double maxHealth;
        Event event = wrapper.getEvent();
        if (!(event instanceof EntityDamageEvent)) {
            return false;
        }
        EntityDamageEvent Eevent = (EntityDamageEvent)event;
        Entity entity = Eevent.getEntity();
        if (!(entity instanceof Player)) {
            return false;
        }
        RaCPlayer racPlayer = wrapper.getPlayer();
        double health = racPlayer.getHealth() - Eevent.getDamage();
        double percent = 100.0 * health / (maxHealth = racPlayer.getMaxHealth());
        return percent <= activationLimit;
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return false;
    }
}

