/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.JumpHeightIncreaseTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class JumpHeightIncreaseTrait
extends AbstractPassiveTrait {
    private List<String> jumpingPlayer = new LinkedList<String>();
    private Set<String> preventNextFallDamage = new HashSet<String>();
    private boolean preventFalldamage = false;
    private final int ticksToPreventFallDamage = 30;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerMoveEvent.class, EntityDamageEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "JumpHeightIncreaseTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "height: " + this.value + " blocks.";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="value", classToExpect=Double.class), @TraitConfigurationField(fieldName="preventFalldamage", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = (Double)configMap.get("value");
        if (configMap.containsKey("preventFalldamage")) {
            this.preventFalldamage = (Boolean)configMap.get("preventFalldamage");
        }
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (!(event instanceof PlayerMoveEvent)) {
            return TraitResults.False();
        }
        PlayerMoveEvent Eevent = (PlayerMoveEvent)event;
        Player player = Eevent.getPlayer();
        if (Eevent.getFrom().getY() < Eevent.getTo().getY() && !this.jumpingPlayer.contains(player.getName())) {
            this.jumpingPlayer.add(player.getName());
            if (this.preventFalldamage) {
                final String name = player.getName();
                this.preventNextFallDamage.add(name);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        JumpHeightIncreaseTrait.this.preventNextFallDamage.remove(name);
                    }
                }, 30L);
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 20, (int)this.value));
            return TraitResults.True();
        }
        if (Eevent.getFrom().getY() > Eevent.getTo().getY()) {
            this.jumpingPlayer.remove(player.getName());
            return TraitResults.True();
        }
        return TraitResults.False();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Your Jump height will be increased.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof JumpHeightIncreaseTrait)) {
            return false;
        }
        JumpHeightIncreaseTrait otherTrait = (JumpHeightIncreaseTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="JumpHeightIncreaseTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (event instanceof EntityDamageEvent) {
            if (!this.preventFalldamage) {
                return false;
            }
            EntityDamageEvent damageEvent = (EntityDamageEvent)event;
            if (damageEvent.getEntityType() == EntityType.PLAYER) {
                Player player = (Player)damageEvent.getEntity();
                if (damageEvent.getCause() == EntityDamageEvent.DamageCause.FALL && this.preventNextFallDamage.contains(player.getName())) {
                    damageEvent.setCancelled(true);
                    return false;
                }
            }
            return false;
        }
        return true;
    }
}

