/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.HungerReplenishTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class HungerReplenishTrait
extends AbstractPassiveTrait {
    @Override
    @TraitEventsUsed(registerdClasses={FoodLevelChangeEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "HungerReplenishTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Hunger regeneration: " + this.operation + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class), @TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = (String)configMap.get("operation");
        this.value = (Double)configMap.get("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        FoodLevelChangeEvent Eevent = (FoodLevelChangeEvent)event;
        Player player = (Player)Eevent.getEntity();
        int orgValue = player.getFoodLevel();
        int newValue = Eevent.getFoodLevel();
        int newCalcValue = (int)Math.ceil(this.getNewValue(eventWrapper.getPlayer(), newValue - orgValue, "value") + (double)orgValue);
        Eevent.setFoodLevel(newCalcValue);
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Your hunger gained will be modified by a value.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof HungerReplenishTrait)) {
            return false;
        }
        HungerReplenishTrait otherTrait = (HungerReplenishTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="HungerReplenishTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (!(event instanceof FoodLevelChangeEvent)) {
            return false;
        }
        FoodLevelChangeEvent Eevent = (FoodLevelChangeEvent)event;
        if (!(Eevent.getEntity() instanceof Player)) {
            return false;
        }
        Player player = (Player)Eevent.getEntity();
        int orgValue = player.getFoodLevel();
        int newValue = Eevent.getFoodLevel();
        return newValue > orgValue;
    }
}

