/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.HungerDecreaseTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.TickEverySecondsTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class HungerDecreaseTrait
extends TickEverySecondsTrait {
    private int amount = 1;

    @Override
    public String getName() {
        return "HungerDecreaseTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Hunger decrease: " + this.amount + " every " + this.seconds + " second";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="amount", classToExpect=Integer.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.amount = configMap.getAsInt("amount", 1);
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Your hunger will decrease by time.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof HungerDecreaseTrait)) {
            return false;
        }
        HungerDecreaseTrait otherTrait = (HungerDecreaseTrait)trait;
        return this.amount <= otherTrait.amount;
    }

    @Override
    @TraitInfos(category="passive", traitName="HungerDecreaseTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (!(event instanceof FoodLevelChangeEvent)) {
            return false;
        }
        FoodLevelChangeEvent Eevent = (FoodLevelChangeEvent)event;
        if (!(Eevent.getEntity() instanceof Player)) {
            return false;
        }
        Player player = (Player)Eevent.getEntity();
        int orgValue = player.getFoodLevel();
        int newValue = Eevent.getFoodLevel();
        return newValue > orgValue;
    }

    @Override
    protected boolean tickDoneForPlayer(RaCPlayer player) {
        Player rPlayer = player.getPlayer();
        int hunger = rPlayer.getFoodLevel();
        float saturation = rPlayer.getSaturation();
        if (saturation > 0.0f) {
            rPlayer.setSaturation(Math.max(0.0f, saturation - (float)this.amount));
        } else if (hunger > this.amount) {
            rPlayer.setFoodLevel(Math.max(1, hunger - this.amount));
        }
        return true;
    }

    @Override
    protected String getPrettyConfigurationPre() {
        return "Hunger decrease: " + this.amount;
    }
}

