/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.HorseRestrictionTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.NeedMC1_6;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;

@NeedMC1_6
public class HorseRestrictionTrait
extends AbstractBasicTrait {
    private final String MOUNT_PATH = "mount";
    private final String LEASH_PATH = "leash";
    private final String CHEST_PATH = "chest";
    private final String JUMPING_PATH = "jumping";
    private final String TAME_PATH = "tame";
    private boolean mount = true;
    private boolean leash = true;
    private boolean chest = true;
    private boolean tame = true;
    private boolean jumping = true;

    @Override
    @TraitEventsUsed(registerdClasses={EntityTameEvent.class, HorseJumpEvent.class, PlayerLeashEntityEvent.class, PlayerUnleashEntityEvent.class, PlayerInteractEntityEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "HorseRestrictionTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        String forbidden = "forbidden: ";
        if (!this.mount) {
            forbidden = String.valueOf(forbidden) + "mounting ";
        }
        if (!this.chest) {
            forbidden = String.valueOf(forbidden) + "chesting ";
        }
        if (!this.tame) {
            forbidden = String.valueOf(forbidden) + "taming ";
        }
        if (!this.leash) {
            forbidden = String.valueOf(forbidden) + "leashing ";
        }
        if (!this.jumping) {
            forbidden = String.valueOf(forbidden) + "jumping";
        }
        if (forbidden.equals("forbidden: ")) {
            forbidden = String.valueOf(forbidden) + "nothing. :)";
        }
        return forbidden;
    }

    @Override
    @TraitInfos(category="passive", traitName="HorseRestrictionTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (event instanceof EntityTameEvent && !this.tame) {
            EntityTameEvent tameEvent = (EntityTameEvent)event;
            if (tameEvent.getEntityType() != EntityType.HORSE) {
                return TraitResults.False();
            }
            tameEvent.setCancelled(true);
            eventWrapper.getPlayer().sendTranslatedMessage("trait_horse_no_tame");
            return TraitResults.True();
        }
        if (!(!(event instanceof PlayerInteractEntityEvent) || this.mount && this.chest)) {
            PlayerInteractEntityEvent pieEvent = (PlayerInteractEntityEvent)event;
            Player player = pieEvent.getPlayer();
            if (!this.chest && pieEvent.getRightClicked().getType() == EntityType.HORSE && player.getInventory().getItem(player.getInventory().getHeldItemSlot()).getType() == Material.CHEST) {
                pieEvent.setCancelled(true);
                return TraitResults.True();
            }
            if (pieEvent.getRightClicked().getType() == EntityType.HORSE && !this.mount) {
                pieEvent.setCancelled(true);
                return TraitResults.True();
            }
            return TraitResults.False();
        }
        if (event instanceof HorseJumpEvent && !this.jumping) {
            HorseJumpEvent hjEvent = (HorseJumpEvent)event;
            hjEvent.setCancelled(true);
            eventWrapper.getPlayer().sendTranslatedMessage("trait_horse_no_jump");
            return TraitResults.True();
        }
        if (event instanceof PlayerLeashEntityEvent && !this.leash) {
            PlayerLeashEntityEvent pleEvent = (PlayerLeashEntityEvent)event;
            pleEvent.setCancelled(true);
            eventWrapper.getPlayer().sendTranslatedMessage("trait_horse_no_leash");
            return TraitResults.True();
        }
        if (event instanceof PlayerUnleashEntityEvent && !this.leash) {
            ((Cancellable)event).setCancelled(true);
            eventWrapper.getPlayer().sendTranslatedMessage("trait_horse_no_leash");
            return TraitResults.True();
        }
        return TraitResults.False();
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="leash", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="chest", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="jumping", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="mount", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="tame", classToExpect=Boolean.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("leash")) {
            this.leash = configMap.getAsBool("leash");
        }
        if (configMap.containsKey("chest")) {
            this.chest = configMap.getAsBool("chest");
        }
        if (configMap.containsKey("jumping")) {
            this.jumping = configMap.getAsBool("jumping");
        }
        if (configMap.containsKey("mount")) {
            this.mount = configMap.getAsBool("mount");
        }
        if (configMap.containsKey("tame")) {
            this.tame = configMap.getAsBool("tame");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait limits the usage of Horses.");
        helpList.add(ChatColor.YELLOW + "You can limit mounting, taming, leashing, putting chests and jumping.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (event instanceof EntityTameEvent && !this.tame) {
            return true;
        }
        if (!(!(event instanceof PlayerInteractEntityEvent) || this.mount && this.chest)) {
            PlayerInteractEntityEvent pieEvent = (PlayerInteractEntityEvent)event;
            Player player = pieEvent.getPlayer();
            if (!this.chest && pieEvent.getRightClicked().getType() == EntityType.HORSE && player.getInventory().getItem(player.getInventory().getHeldItemSlot()).getType() == Material.CHEST) {
                return true;
            }
            return pieEvent.getRightClicked().getType() == EntityType.HORSE && !this.mount;
        }
        if (event instanceof HorseJumpEvent && !this.jumping) {
            HorseJumpEvent hjEvent = (HorseJumpEvent)event;
            Entity passenger = hjEvent.getEntity().getPassenger();
            return passenger != null && passenger instanceof Player;
        }
        if (event instanceof PlayerLeashEntityEvent && !this.leash) {
            PlayerLeashEntityEvent pleEvent = (PlayerLeashEntityEvent)event;
            return pleEvent.getEntity().getType() == EntityType.HORSE;
        }
        if (event instanceof PlayerUnleashEntityEvent && !this.leash) {
            PlayerUnleashEntityEvent pleEvent = (PlayerUnleashEntityEvent)event;
            return pleEvent.getEntity().getType() == EntityType.HORSE;
        }
        return false;
    }
}

