/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.FasterSprintingTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSprintEvent;

public class FasterSprintingTrait
extends AbstractBasicTrait {
    private static final double NORMAL_MOD = 0.3;
    private double sprintMod = 0.3;
    private final Set<UUID> sprinting = new HashSet<UUID>();

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        plugin.registerEvents(this);
    }

    @EventHandler
    public void playerStartSprinting(PlayerToggleSprintEvent event) {
        if (event.isCancelled()) {
            return;
        }
        boolean sprinting = event.isSprinting();
        Player player = event.getPlayer();
        UUID id = player.getUniqueId();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        if (!TraitHolderCombinder.checkContainer(racPlayer, this)) {
            return;
        }
        if (sprinting) {
            if (super.checkRestrictions(EventWrapperFactory.buildFromEvent((Event)event)) != TraitRestriction.None) {
                return;
            }
            this.sprinting.add(id);
            player.setWalkSpeed((float)this.sprintMod);
        } else {
            this.sprinting.remove(id);
            player.setWalkSpeed(0.3f);
        }
    }

    @Override
    public String getName() {
        return "FasterSprintingTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Sprint fast: " + this.sprintMod;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="speed", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.sprintMod = configMap.getAsDouble("speed");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        return TraitResults.False();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you sprint faster.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof FasterSprintingTrait)) {
            return false;
        }
        FasterSprintingTrait otherTrait = (FasterSprintingTrait)trait;
        return this.sprintMod >= otherTrait.sprintMod;
    }

    @Override
    @TraitInfos(category="passive", traitName="FasterSprintingTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return false;
    }
}

