/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.DwarfSkinTrait;

import de.tobiyas.racesandclasses.APIs.CooldownApi;
import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.MessageScheduleApi;
import de.tobiyas.racesandclasses.configuration.traits.TraitConfig;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class DwarfSkinTrait
extends AbstractPassiveTrait {
    private static int duration = 10;
    private static double activationLimit = 30.0;
    private final Set<String> currentlyActive = new HashSet<String>();

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
        TraitConfig config = plugin.getConfigManager().getTraitConfigManager().getConfigOfTrait(this.getName());
        if (config != null) {
            duration = (Integer)config.getValue("trait.duration", 10);
            activationLimit = config.getDouble("trait.activationLimit", 30.0);
        }
    }

    @Override
    public String getName() {
        return "DwarfSkinTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "damage Reduce: " + this.operation + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class), @TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = (String)configMap.get("operation");
        this.value = (Double)configMap.get("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (!(event instanceof EntityDamageEvent)) {
            return TraitResults.False();
        }
        EntityDamageEvent Eevent = (EntityDamageEvent)event;
        Entity entity = Eevent.getEntity();
        if (entity.getType() != EntityType.PLAYER) {
            return TraitResults.False();
        }
        final Player player = (Player)entity;
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        double maxHealth = racPlayer.getMaxHealth();
        double currentHealth = racPlayer.getHealth();
        double healthPercent = 100.0 * currentHealth / maxHealth;
        if (healthPercent > activationLimit) {
            return TraitResults.False();
        }
        if (!this.currentlyActive.contains(player.getName())) {
            this.currentlyActive.add(player.getName());
            this.activateMessage(player);
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    DwarfSkinTrait.this.currentlyActive.remove(player.getName());
                    int leftCooldown = DwarfSkinTrait.this.cooldownTime - duration;
                    if (leftCooldown > 0) {
                        CooldownApi.setPlayerCooldown(player.getName(), "trait." + DwarfSkinTrait.this.getDisplayName(), leftCooldown);
                    }
                }
            }, (long)(20 * duration));
        }
        if (this.currentlyActive.contains(player.getName())) {
            double oldValue = CompatibilityModifier.EntityDamage.safeGetDamage(Eevent);
            double newValue = this.getNewValue(eventWrapper.getPlayer(), oldValue, "value");
            CompatibilityModifier.EntityDamage.safeSetDamage(newValue, Eevent);
            return TraitResults.True();
        }
        return TraitResults.False();
    }

    private void activateMessage(Player player) {
        LanguageAPI.sendTranslatedMessage((CommandSender)player, "trait_toggled", "name", this.getDisplayName());
        MessageScheduleApi.scheduleTranslateMessageToPlayer(player.getName(), duration, "trait_faded", "name", this.getDisplayName());
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof DwarfSkinTrait)) {
            return false;
        }
        DwarfSkinTrait otherTrait = (DwarfSkinTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="DwarfSkinTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait decreases your taken damage when you drop below " + activationLimit + "% health.");
        helpList.add(ChatColor.YELLOW + "This only lasts " + duration + " seconds and only occurs every " + "X" + " seconds");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.TAKE_DAMAGE) {
            return false;
        }
        RaCPlayer player = wrapper.getPlayer();
        double maxHealth = player.getMaxHealth();
        double currentHealth = player.getHealth();
        double healthPercent = 100.0 * currentHealth / maxHealth;
        return !(healthPercent > activationLimit);
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return false;
    }
}

