/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.DodgeTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class DodgeTrait
extends AbstractPassiveTrait {
    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "DodgeTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "dodgeChance: " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="chance", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = configMap.getAsDouble("chance");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        EntityDamageEvent Eevent = (EntityDamageEvent)event;
        double num = new Random().nextDouble() * 100.0;
        if (num <= this.modifyToPlayer(eventWrapper.getPlayer(), this.value, "chance")) {
            Eevent.setCancelled(true);
            Player player = (Player)Eevent.getEntity();
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ARROW_SHOOT, 10.0f, 1.0f);
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "trait_dodged");
        }
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Your have the chance to Dodge an attack.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof DodgeTrait)) {
            return false;
        }
        DodgeTrait otherTrait = (DodgeTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="DodgeTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.TAKE_DAMAGE) {
            return false;
        }
        EntityDamageEvent.DamageCause cause = wrapper.getDamageCause();
        return cause == EntityDamageEvent.DamageCause.ENTITY_ATTACK || cause == EntityDamageEvent.DamageCause.PROJECTILE;
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return false;
    }
}

