/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.DamageReduceTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamageReduceTrait
extends AbstractPassiveTrait {
    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "DamageReduceTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "damage reduce: " + this.operation + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class), @TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = (String)configMap.get("operation");
        this.value = (Double)configMap.get("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (!(event instanceof EntityDamageEvent)) {
            return TraitResults.False();
        }
        EntityDamageEvent Eevent = (EntityDamageEvent)event;
        if (Eevent.getEntityType() != EntityType.PLAYER) {
            return TraitResults.False();
        }
        double oldValue = CompatibilityModifier.EntityDamage.safeGetDamage(Eevent);
        double newValue = this.getNewValue(eventWrapper.getPlayer(), oldValue, "value");
        CompatibilityModifier.EntityDamage.safeSetDamage(newValue, Eevent);
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Your taken damage will be decreased or divided by an value.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof DamageReduceTrait)) {
            return false;
        }
        DamageReduceTrait otherTrait = (DamageReduceTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="DamageReduceTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (!(event instanceof EntityDamageEvent)) {
            return false;
        }
        EntityDamageEvent Eevent = (EntityDamageEvent)event;
        return Eevent.getEntityType() == EntityType.PLAYER;
    }
}

