/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.DamageIncreaseTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamageIncreaseTrait
extends AbstractPassiveTrait {
    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "DamageIncreaseTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "damage: " + this.operation + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class), @TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = (String)configMap.get("operation");
        this.value = (Double)configMap.get("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        Entity entity = Eevent.getDamager();
        if (entity instanceof Arrow) {
            entity = CompatibilityModifier.Shooter.getShooter((Projectile)((Arrow)entity));
        }
        double oldValue = CompatibilityModifier.EntityDamage.safeGetDamage((EntityDamageEvent)Eevent);
        double newValue = this.getNewValue(eventWrapper.getPlayer(), oldValue, "value");
        CompatibilityModifier.EntityDamage.safeSetDamage(newValue, (EntityDamageEvent)Eevent);
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Your Damage will be increased by a value or times an value.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof DamageIncreaseTrait)) {
            return false;
        }
        DamageIncreaseTrait otherTrait = (DamageIncreaseTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="DamageIncreaseTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        Event event = wrapper.getEvent();
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return false;
        }
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        Entity entity = Eevent.getDamager();
        if (entity instanceof Arrow) {
            entity = CompatibilityModifier.Shooter.getShooter((Projectile)((Arrow)entity));
        }
        return entity instanceof Player;
    }
}

