/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.CommandTrait;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class CommandTrait
extends AbstractMagicSpellTrait {
    private String startCommmand = "";
    private String endCommand = "";
    private int timeBetween = 10;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "CommandTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Mana: " + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="CommandTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof CommandTrait)) {
            return false;
        }
        CommandTrait otherTrait = (CommandTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait uses a command at start and end.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(final RaCPlayer player, TraitResults result) {
        String startCommandToEdit = this.startCommmand.replaceAll("@p", player.getName());
        final String endCommandToEdit = this.endCommand.replaceAll("@p", player.getName());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)startCommandToEdit);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)endCommandToEdit);
            }
        }, (long)(20 * this.timeBetween));
        result.setTriggered(true);
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="start", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="end", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="time", classToExpect=Integer.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        if (configMap.containsKey("start")) {
            this.startCommmand = (String)configMap.get("start");
        }
        if (configMap.containsKey("end")) {
            this.endCommand = (String)configMap.get("end");
        }
        if (configMap.containsKey("time")) {
            this.timeBetween = (Integer)configMap.get("time");
        }
        super.setConfiguration(configMap);
    }

    @Override
    public boolean isStackable() {
        return true;
    }
}

