/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.BashTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.StunAPI;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class BashTrait
extends AbstractPassiveTrait {
    private double duration = 1.0;

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "BashTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Stun Chance: " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="chance", classToExpect=Double.class, optional=false), @TraitConfigurationField(fieldName="duration", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.value = (Double)configMap.get("chance");
        if (configMap.containsKey("duration")) {
            this.duration = (Double)configMap.get("duration");
        }
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        double num = new Random().nextDouble() * 100.0;
        if (num <= this.modifyToPlayer(eventWrapper.getPlayer(), this.value, "chance")) {
            Eevent.setCancelled(true);
            Player player = (Player)Eevent.getDamager();
            LivingEntity target = (LivingEntity)Eevent.getEntity();
            Entity damager = Eevent.getDamager();
            int ticks = (int)Math.floor(this.duration * 20.0);
            StunAPI.StunEntity.stunEntityForTicks(damager, (Entity)target, ticks);
            String targetName = target instanceof Player ? ((Player)target).getName() : target.getType().name().toLowerCase();
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "trait_bash_success", "name", targetName);
        }
        return TraitResults.True();
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Your have the chance to Stun an enemy for short time.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof BashTrait)) {
            return false;
        }
        BashTrait otherTrait = (BashTrait)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    @TraitInfos(category="passive", traitName="BashTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.DO_DAMAGE) {
            return false;
        }
        EntityDamageEvent.DamageCause cause = wrapper.getDamageCause();
        return cause == EntityDamageEvent.DamageCause.ENTITY_ATTACK;
    }

    @Override
    public boolean notifyTriggeredUplinkTime(EventWrapper wrapper) {
        return false;
    }
}

