/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.passive.ArrowDamageIncreaseTrait;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class ArrowDamageIncreaseTrait
extends AbstractPassiveTrait {
    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "ArrowDamageIncreaseTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "damage: " + this.operation + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class, optional=false), @TraitConfigurationField(fieldName="value", classToExpect=Double.class, optional=false)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = (String)configMap.get("operation");
        this.value = (Double)configMap.get("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return TraitResults.False();
        }
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        if (Eevent.getDamager().getType() != EntityType.ARROW) {
            return TraitResults.False();
        }
        Arrow arrow = (Arrow)Eevent.getDamager();
        LivingEntity shooter = CompatibilityModifier.Shooter.getShooter((Projectile)arrow);
        if (shooter == null || shooter.getType() != EntityType.PLAYER) {
            return TraitResults.False();
        }
        Player playerShooter = (Player)shooter;
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(playerShooter);
        if (TraitHolderCombinder.checkContainer(racPlayer, this)) {
            double oldDamage = CompatibilityModifier.EntityDamage.safeGetDamage((EntityDamageEvent)Eevent);
            double newValue = this.getNewValue(racPlayer, oldDamage, "value");
            CompatibilityModifier.EntityDamage.safeSetDamage(newValue, (EntityDamageEvent)Eevent);
            return TraitResults.True();
        }
        return TraitResults.False();
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    @TraitInfos(category="passive", traitName="ArrowDamageIncreaseTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait increases the damage of your Arrows.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.DO_DAMAGE) {
            return false;
        }
        return wrapper.isArrowInvolved();
    }
}

