/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.WeaponNextHitDebuffTrait;

import de.tobiyas.racesandclasses.APIs.DebuffAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.entitystatusmanager.debuff.Debuff;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractBuffTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WeaponNextHitDebuffTrait
extends AbstractBuffTrait
implements Listener {
    private final Set<Material> weaponMats = new HashSet<Material>();
    private DebuffType type = DebuffType.OUTGOING_DAMAGE_REDUCE;
    private double percent = 0.2;

    public WeaponNextHitDebuffTrait() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RacesAndClasses.getPlugin());
    }

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "WeaponNextHitDebuffTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return this.weaponMats + " " + this.type.name() + ": " + this.percent;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="weapons", classToExpect=List.class, optional=false), @TraitConfigurationField(fieldName="type", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="percent", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        List<String> weapons = configMap.getAsStringList("weapons");
        for (String weapon : weapons) {
            Material mat = Material.matchMaterial((String)weapon);
            if (mat == null) continue;
            this.weaponMats.add(mat);
        }
        if (configMap.containsKey("type")) {
            String name = configMap.getAsString("type");
            name = name.replace(" ", "_");
            name = name.toUpperCase();
            DebuffType[] debuffTypeArray = DebuffType.values();
            int n = debuffTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebuffType one = debuffTypeArray[n2];
                if (one.name().equalsIgnoreCase(name)) {
                    this.type = one;
                }
                ++n2;
            }
        }
        if (configMap.containsKey("percent")) {
            this.percent = configMap.getAsDouble("percent");
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    @Override
    @TraitInfos(category="magic", traitName="WeaponNextHitDebuffTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This buff increases your next hit with the desired weapon.");
        return helpList;
    }

    @EventHandler
    public void entityDamage(EntityDamageByEntityEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return;
        }
        Entity damagerEntity = event.getDamager();
        if (!(damagerEntity instanceof Player)) {
            return;
        }
        RaCPlayer damager = RaCPlayerManager.get().getPlayer((Player)event.getDamager());
        if (!TraitHolderCombinder.checkContainer(damager, this)) {
            return;
        }
        if (this.isActive(damager)) {
            ItemStack inHand = damager.getPlayer().getItemInHand();
            if (inHand == null) {
                return;
            }
            if (!this.weaponMats.contains(inHand.getType())) {
                return;
            }
            this.buffUsed(damager);
            DebuffAPI.registerNewDebuff(this.generateDebuff(event.getEntity().getUniqueId()));
        }
    }

    private Debuff generateDebuff(UUID uniqueId) {
        return new Debuff(this.getDisplayName(), this.duration, 20, uniqueId){

            @Override
            protected void realTick() {
            }

            @Override
            public double modifyIncomingDamage(double value) {
                switch (WeaponNextHitDebuffTrait.this.type) {
                    case INCOMING_DAMAGE_INCREASE: {
                        return value * (1.0 + WeaponNextHitDebuffTrait.this.percent);
                    }
                    case INCOMING_DAMAGE_REDUCE: {
                        return value * WeaponNextHitDebuffTrait.this.percent;
                    }
                }
                return value;
            }

            @Override
            public double modifyOutgoingDamage(double value) {
                switch (WeaponNextHitDebuffTrait.this.type) {
                    case OUTGOING_DAMAGE_INCREASE: {
                        return value * (1.0 + WeaponNextHitDebuffTrait.this.percent);
                    }
                    case OUTGOING_DAMAGE_REDUCE: {
                        return value * WeaponNextHitDebuffTrait.this.percent;
                    }
                }
                return value;
            }
        };
    }

    @Override
    protected void buffActivated(RaCPlayer arg0) {
    }

    @Override
    protected void buffTimeouted(RaCPlayer arg0) {
    }

    public static enum DebuffType {
        INCOMING_DAMAGE_REDUCE,
        INCOMING_DAMAGE_INCREASE,
        OUTGOING_DAMAGE_REDUCE,
        OUTGOING_DAMAGE_INCREASE;

    }
}

