/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.WeaponNextHitDamageIncreaseBuffTrait;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractBuffTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WeaponNextHitDamageIncreaseBuffTrait
extends AbstractBuffTrait
implements Listener {
    private final Set<Material> weaponMats = new HashSet<Material>();
    private double damage = 1.0;

    public WeaponNextHitDamageIncreaseBuffTrait() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RacesAndClasses.getPlugin());
    }

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "WeaponNextHitDamageIncreaseBuffTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return this.weaponMats + " " + this.damage;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="weapons", classToExpect=List.class, optional=false), @TraitConfigurationField(fieldName="damage", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        List<String> weapons = configMap.getAsStringList("weapons");
        for (String weapon : weapons) {
            Material mat = Material.matchMaterial((String)weapon);
            if (mat == null) continue;
            this.weaponMats.add(mat);
        }
        if (configMap.containsKey("damage")) {
            this.damage = configMap.getAsDouble("damage");
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    @Override
    @TraitInfos(category="magic", traitName="WeaponNextHitDamageIncreaseBuffTrait", visible=true)
    public void importTrait() {
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This buff increases your next hit with the desired weapon.");
        return helpList;
    }

    @EventHandler
    public void entityDamage(EntityDamageByEntityEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return;
        }
        Entity damagerEntity = event.getDamager();
        if (!(damagerEntity instanceof Player)) {
            return;
        }
        RaCPlayer damager = RaCPlayerManager.get().getPlayer((Player)event.getDamager());
        if (!TraitHolderCombinder.checkContainer(damager, this)) {
            return;
        }
        if (this.isActive(damager)) {
            ItemStack inHand = damager.getPlayer().getItemInHand();
            if (inHand == null) {
                return;
            }
            if (!this.weaponMats.contains(inHand.getType())) {
                return;
            }
            double damage = CompatibilityModifier.EntityDamage.safeGetDamage((EntityDamageEvent)event);
            CompatibilityModifier.EntityDamage.safeSetDamage(damage += this.modifyToPlayer(damager, this.damage, "damage"), (EntityDamageEvent)event);
            this.buffUsed(damager);
            damager.sendMessage(ChatColor.GREEN + "~~ HARD HIT ~~");
        }
    }

    @Override
    protected void buffActivated(RaCPlayer arg0) {
    }

    @Override
    protected void buffTimeouted(RaCPlayer arg0) {
    }
}

