/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.WallTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.WallTrait.OldWallBlocks;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractContinousCostMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class WallTrait
extends AbstractContinousCostMagicSpellTrait
implements Listener {
    private Material material = Material.GLASS;
    private Map<String, OldWallBlocks> wallBlocks = new HashMap<String, OldWallBlocks>();

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "WallTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        return "duration: " + time + " seconds. Mana: " + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="WallTrait", visible=true)
    public void importTrait() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        int otherTime;
        if (!(trait instanceof WallTrait)) {
            return false;
        }
        WallTrait otherTrait = (WallTrait)trait;
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        int n = otherTime = otherTrait.everyXSeconds <= 0 ? otherTrait.durationInSeconds : otherTrait.everyXSeconds;
        return time > otherTime;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="material", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        String material;
        Material castedMaterial;
        super.setConfiguration(configMap);
        this.material = Material.GLASS;
        if (configMap.containsKey("material") && (castedMaterial = Material.getMaterial((String)(material = (String)configMap.get("material")))) != null && castedMaterial.isBlock()) {
            this.material = castedMaterial;
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "Castes a Wall infront of you.");
        return helpList;
    }

    @Override
    protected boolean activateIntern(RaCPlayer player) {
        List blocks = player.getPlayer().getLineOfSight(new HashSet(), 3);
        Location location = ((Block)blocks.get(blocks.size() - 1)).getLocation();
        Location from = location.clone();
        Location to = location.clone();
        BlockFace face = this.getDirection(player.getLocation().getYaw(), player.getLocation().getPitch());
        switch (face) {
            case NORTH: {
                from.add(-2.0, 1.0, -2.0);
                to.add(2.0, -1.0, -2.0);
                break;
            }
            case EAST: {
                from.add(2.0, 1.0, -2.0);
                to.add(2.0, -1.0, 2.0);
                break;
            }
            case SOUTH: {
                from.add(-2.0, 1.0, 2.0);
                to.add(2.0, -1.0, 2.0);
                break;
            }
            case WEST: {
                from.add(-2.0, 1.0, -2.0);
                to.add(-2.0, -1.0, 2.0);
                break;
            }
            case UP: {
                from.add(-2.0, 2.0, -2.0);
                to.add(2.0, 2.0, 2.0);
                break;
            }
            case DOWN: {
                from.add(-2.0, -2.0, -2.0);
                to.add(2.0, -2.0, 2.0);
                break;
            }
        }
        OldWallBlocks oldBlocks = new OldWallBlocks(from, to, this.material);
        this.wallBlocks.put(player.getName(), oldBlocks);
        LanguageAPI.sendTranslatedMessage(player, "trait_wall_success");
        return true;
    }

    @Override
    protected boolean deactivateIntern(RaCPlayer player) {
        OldWallBlocks blocks = this.wallBlocks.get(player.getName());
        if (blocks != null) {
            blocks.removeWall();
        }
        LanguageAPI.sendTranslatedMessage(player, "trait_wall_faded");
        return true;
    }

    @EventHandler
    public void onPlayerBreakBlock(BlockBreakEvent event) {
        Block block = event.getBlock();
        for (OldWallBlocks old : this.wallBlocks.values()) {
            if (!old.contains(block.getLocation())) continue;
            event.setCancelled(true);
            old.remove(block);
            break;
        }
    }

    private BlockFace getDirection(float yaw, float pitch) {
        if (pitch < -65.0f) {
            return BlockFace.UP;
        }
        if (pitch > 65.0f) {
            return BlockFace.DOWN;
        }
        yaw /= 90.0f;
        if ((yaw = (float)Math.round(yaw)) == -4.0f || yaw == 0.0f || yaw == 4.0f) {
            return BlockFace.SOUTH;
        }
        if (yaw == -1.0f || yaw == 3.0f) {
            return BlockFace.EAST;
        }
        if (yaw == -2.0f || yaw == 2.0f) {
            return BlockFace.NORTH;
        }
        if (yaw == -3.0f || yaw == 1.0f) {
            return BlockFace.WEST;
        }
        return BlockFace.NORTH;
    }

    @Override
    protected boolean tickInternal(RaCPlayer player) {
        return true;
    }
}

