/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.WallTrait;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.InventoryHolder;

public class OldWallBlocks {
    private Map<Location, BlockData> blockList = new HashMap<Location, BlockData>();
    private final Material newMaterial;

    public OldWallBlocks(Location from, Location to, Material newMaterial) {
        this.newMaterial = newMaterial;
        this.generateBlockList(from, to);
    }

    public void removeWall() {
        for (Map.Entry<Location, BlockData> entry : this.blockList.entrySet()) {
            BlockData data = entry.getValue();
            Location location = entry.getKey();
            location.getBlock().setType(data.material);
            location.getBlock().setData(data.data);
        }
    }

    private void generateBlockList(Location from, Location to) {
        int smaller = from.getBlockY() > to.getBlockY() ? to.getBlockY() : from.getBlockY();
        int larger = from.getBlockY() < to.getBlockY() ? to.getBlockY() : from.getBlockY();
        int i = smaller;
        while (i <= larger) {
            for (Location location : this.getLocationsBetween(from, to, i)) {
                if (location.getBlock().getState() instanceof InventoryHolder || location.getBlock().getType() != Material.AIR) continue;
                BlockData data = new BlockData();
                data.data = location.getBlock().getData();
                data.material = location.getBlock().getType();
                this.blockList.put(location, data);
                location.getBlock().setType(this.newMaterial);
            }
            ++i;
        }
    }

    public void remove(Block block) {
        for (Location loc : this.blockList.keySet()) {
            if (!loc.getBlock().equals(block)) continue;
            BlockData data = this.blockList.get(loc);
            block.setTypeIdAndData(data.material.getId(), data.data, true);
            this.blockList.remove(loc);
            return;
        }
    }

    private List<Location> getLocationsBetween(Location from, Location to, int height) {
        LinkedList<Location> locations;
        block5: {
            block6: {
                block4: {
                    locations = new LinkedList<Location>();
                    if (from.getBlockX() != to.getBlockX()) break block4;
                    int smaller = from.getBlockZ() < to.getBlockZ() ? from.getBlockZ() : to.getBlockZ();
                    int larger = from.getBlockZ() > to.getBlockZ() ? from.getBlockZ() : to.getBlockZ();
                    int i = smaller;
                    while (i <= larger) {
                        Location newLocation = from.clone();
                        newLocation.setZ((double)i);
                        newLocation.setY((double)height);
                        locations.add(newLocation);
                        ++i;
                    }
                    break block5;
                }
                if (from.getBlockZ() != to.getBlockZ()) break block6;
                int smaller = from.getBlockX() < to.getBlockX() ? from.getBlockX() : to.getBlockX();
                int larger = from.getBlockX() > to.getBlockX() ? from.getBlockX() : to.getBlockX();
                int i = smaller;
                while (i <= larger) {
                    Location newLocation = from.clone();
                    newLocation.setX((double)i);
                    newLocation.setY((double)height);
                    locations.add(newLocation);
                    ++i;
                }
                break block5;
            }
            if (from.getBlockY() != to.getBlockY()) break block5;
            int smallerX = from.getBlockX() < to.getBlockX() ? from.getBlockX() : to.getBlockX();
            int largerX = from.getBlockX() > to.getBlockX() ? from.getBlockX() : to.getBlockX();
            int i = smallerX;
            while (i <= largerX) {
                int smallerY = from.getBlockZ() < to.getBlockZ() ? from.getBlockZ() : to.getBlockZ();
                int largerY = from.getBlockZ() > to.getBlockZ() ? from.getBlockZ() : to.getBlockZ();
                int j = smallerY;
                while (j <= largerY) {
                    Location newLocation = from.clone();
                    newLocation.setX((double)i);
                    newLocation.setZ((double)j);
                    newLocation.setY((double)height);
                    locations.add(newLocation);
                    ++j;
                }
                ++i;
            }
        }
        return locations;
    }

    public boolean contains(Location blockLocation) {
        Block block = blockLocation.getBlock();
        for (Location location : this.blockList.keySet()) {
            if (!block.equals(location.getBlock())) continue;
            return true;
        }
        return false;
    }

    private class BlockData {
        Material material;
        byte data;

        private BlockData() {
        }
    }
}

