/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.ThrowItemsAroundSpellTrait;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.damage.PreEntityDamageEvent;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ThrowItemsAroundSpellTrait
extends AbstractMagicSpellTrait
implements Listener {
    protected double damage = 1.0;
    protected Material mat = Material.WOOD_SWORD;
    protected double speed = 3.0;
    protected int matDamageValue = 0;
    protected ParticleContainer particles = null;
    protected ParticleContainer particlesFromSelf = null;
    protected final Set<Item> flying = new HashSet<Item>();
    protected int amount = 3;
    protected double split = 3.0;
    private final String DELETE_ON_DROP = "MASS_ITEM_DELETE_ON_DROP";
    private final Random rand = new Random();

    public ThrowItemsAroundSpellTrait() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RacesAndClasses.getPlugin());
        new BukkitRunnable(){

            public void run() {
                Iterator<Item> itemIt = ThrowItemsAroundSpellTrait.this.flying.iterator();
                block0: while (itemIt.hasNext()) {
                    Item item = itemIt.next();
                    if (!item.isValid() || item.getVelocity().length() <= 0.1) {
                        item.remove();
                        itemIt.remove();
                        continue;
                    }
                    List<Entity> nearList = SearchEntity.inCircleAround((Entity)item, 2.0);
                    for (Entity near : nearList) {
                        RaCPlayer thrower;
                        if (!(near instanceof LivingEntity) || !item.hasMetadata("MASS_ITEM_DELETE_ON_DROP") || near.getLocation().add(0.0, 1.0, 0.0).distanceSquared(item.getLocation()) > 1.0 || (thrower = (RaCPlayer)((MetadataValue)item.getMetadata("MASS_ITEM_DELETE_ON_DROP").get(0)).value()).getPlayer() == near) continue;
                        ThrowItemsAroundSpellTrait.this.entityGotHitByItem(thrower, (LivingEntity)near);
                        item.remove();
                        itemIt.remove();
                        continue block0;
                    }
                }
            }
        }.runTaskTimer((Plugin)RacesAndClasses.getPlugin(), 1L, 1L);
    }

    @Override
    public void deInit() {
        super.deInit();
        for (Item item : this.flying) {
            if (!item.isValid()) continue;
            item.remove();
        }
    }

    @Override
    public String getName() {
        return "ThrowItemsAroundSpellTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="damage", classToExpect=Double.class, optional=false), @TraitConfigurationField(fieldName="speed", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="split", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="amount", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="material", classToExpect=Material.class, optional=true), @TraitConfigurationField(fieldName="materialDamageValue", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="particle", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="particleFromSelf", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("material")) {
            this.mat = configMap.getAsMaterial("material");
        }
        if (configMap.containsKey("materialDamageValue")) {
            this.matDamageValue = configMap.getAsInt("materialDamageValue");
        }
        if (configMap.containsKey("damage")) {
            this.damage = configMap.getAsDouble("damage");
        }
        if (configMap.containsKey("split")) {
            this.split = configMap.getAsDouble("split");
        }
        if (configMap.containsKey("amount")) {
            this.amount = configMap.getAsInt("amount");
        }
        if (configMap.containsKey("speed")) {
            this.speed = configMap.getAsDouble("speed");
        }
        if (configMap.containsKey("particle")) {
            this.particles = configMap.getAsParticleContainer("particle");
        }
        if (configMap.containsKey("particleFromSelf")) {
            this.particlesFromSelf = configMap.getAsParticleContainer("particleFromSelf");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This Trait Throws an Item in the Direction you are looking at.");
        return helpList;
    }

    @Override
    @TraitInfos(category="magic", traitName="ThrowItemsAroundSpellTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Does damage on Stuff touching the Thrown Item.";
    }

    private void removeItemAfterX(final Item droppedItem, int time) {
        new BukkitRunnable(){

            public void run() {
                if (droppedItem.isValid()) {
                    droppedItem.remove();
                }
            }
        }.runTaskLater((Plugin)RacesAndClasses.getPlugin(), (long)(20 * time));
    }

    @EventHandler
    public void chunkUnload(ChunkUnloadEvent event) {
        for (Entity entity : Arrays.asList(event.getChunk().getEntities())) {
            if (!entity.hasMetadata("MASS_ITEM_DELETE_ON_DROP")) continue;
            entity.remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerPickup(PlayerPickupItemEvent event) {
        Item item = event.getItem();
        if (item.hasMetadata("MASS_ITEM_DELETE_ON_DROP")) {
            RaCPlayer owner = (RaCPlayer)((MetadataValue)item.getMetadata("MASS_ITEM_DELETE_ON_DROP").get(0)).value();
            if (owner == null) {
                return;
            }
            event.setCancelled(true);
            if (owner.getPlayer() == event.getPlayer()) {
                return;
            }
            if (this.entityGotHitByItem(owner, (LivingEntity)event.getPlayer())) {
                item.remove();
                this.flying.remove(item);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void hopperPickup(InventoryPickupItemEvent event) {
        Item item = event.getItem();
        if (item.hasMetadata("MASS_ITEM_DELETE_ON_DROP")) {
            event.setCancelled(true);
        }
    }

    private boolean entityGotHitByItem(RaCPlayer thrower, LivingEntity target) {
        if (thrower.getPlayer() == target) {
            return false;
        }
        if (!EnemyChecker.areEnemies((Entity)thrower.getPlayer(), (Entity)target)) {
            return false;
        }
        double damage = PreEntityDamageEvent.getRealDamage((Entity)thrower.getPlayer(), (Entity)target, EntityDamageEvent.DamageCause.CONTACT, this.modifyToPlayer(thrower, this.damage, "damage"));
        if (damage <= 0.0) {
            return false;
        }
        target.setNoDamageTicks(0);
        CompatibilityModifier.LivingEntity.safeDamageEntityByEntity(target, (LivingEntity)thrower.getPlayer(), damage);
        target.setNoDamageTicks(20);
        if (this.particles != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.particles, target.getEyeLocation());
        }
        return true;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        ItemStack item = new ItemStack(this.mat);
        item.setDurability((short)((byte)this.matDamageValue));
        double modAmount = this.modifyToPlayer(player, this.amount, "damage");
        int i = 0;
        while ((double)i < modAmount) {
            Item droppedItem = player.getLocation().getWorld().dropItem(player.getLocation().clone().add(0.0, 1.5, 0.0), item);
            droppedItem.setItemStack(item);
            Vector velocity = player.getPlayer().getLocation().getDirection().clone();
            velocity = this.randomize(velocity);
            velocity = velocity.multiply(this.speed);
            droppedItem.setVelocity(velocity);
            droppedItem.setMetadata("MASS_ITEM_DELETE_ON_DROP", (MetadataValue)new FixedMetadataValue((Plugin)RacesAndClasses.getPlugin(), (Object)player));
            droppedItem.setPickupDelay(1);
            this.removeItemAfterX(droppedItem, 5);
            this.flying.add(droppedItem);
            ++i;
        }
        if (this.particlesFromSelf != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.particlesFromSelf, player.getLocation().clone().add(0.0, 1.0, 0.0));
        }
        result.copyFrom(TraitResults.True());
    }

    protected Vector randomize(Vector vec) {
        double off = vec.length() / this.split;
        double xOffset = this.rand.nextDouble() * off - off / 2.0;
        double yOffset = this.rand.nextDouble() * off - off / 2.0;
        double zOffset = this.rand.nextDouble() * off - off / 2.0;
        Vector offset = new Vector(xOffset, yOffset, zOffset);
        return vec.add(offset);
    }
}

