/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.TeleportTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.player.PlayerInteractEvent;

public class TeleportTrait
extends AbstractMagicSpellTrait {
    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "TeleportTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Mana: " + this.cost;
    }

    @Override
    @TraitInfos(category="magic", traitName="TeleportTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof TeleportTrait)) {
            return false;
        }
        TeleportTrait otherTrait = (TeleportTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait teleports you to the place your wand is pointing.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Block toTeleportTo = player.getPlayer().getTargetBlock(null, 100);
        if (toTeleportTo == null) {
            LanguageAPI.sendTranslatedMessage(player, "no_taget_found");
            result.setTriggered(false);
            return;
        }
        int i = 0;
        while (i <= 2) {
            if (toTeleportTo.getRelative(BlockFace.UP).getType().isSolid() || toTeleportTo.getRelative(BlockFace.UP).getRelative(BlockFace.UP).getType().isSolid()) {
                LanguageAPI.sendTranslatedMessage(player, "trait_teleport_solidtarger");
                result.setTriggered(false);
                return;
            }
            ++i;
        }
        player.getPlayer().teleport(toTeleportTo.getRelative(BlockFace.UP).getLocation());
        LanguageAPI.sendTranslatedMessage(player, "trait_teleport_success");
        player.sendMessage(ChatColor.GREEN + "[RaC] Teleported.");
        result.setTriggered(true);
    }
}

