/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.StunSpellTrait;

import de.tobiyas.racesandclasses.APIs.StunAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class StunSpellTrait
extends AbstractMagicSpellTrait {
    private int duration;
    private double range = 5.0;
    private ParticleContainer ownParticle = null;
    private ParticleContainer targetParticle = null;

    @Override
    @TraitInfos(category="magic", traitName="StunSpellTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitEventsUsed
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "StunSpellTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "stuns for " + this.duration + " seconds";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="range", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="targetParticle", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="ownParticle", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("duration")) {
            this.duration = configMap.getAsInt("duration");
        }
        if (configMap.containsKey("range")) {
            this.range = configMap.getAsDouble("range");
        }
        if (configMap.containsKey("targetParticle")) {
            this.targetParticle = configMap.getAsParticleContainer("targetParticle");
        }
        if (configMap.containsKey("ownParticle")) {
            this.ownParticle = configMap.getAsParticleContainer("ownParticle");
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait stuns your opponent.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Object target = SearchEntity.inLineOfSight((int)this.range, (LivingEntity)player.getPlayer());
        if (target == null) {
            result.copyFrom(TraitResults.False());
            return;
        }
        String targetName = "";
        int modDur = this.modifyToPlayer(player, this.duration * 20, "duration");
        if (target instanceof Player) {
            StunAPI.StunPlayer.stunPlayerForTicks((Player)target, modDur);
            targetName = ((Player)target).getDisplayName();
        } else {
            StunAPI.StunEntity.stunEntityForTicks(target, modDur);
            String string = target instanceof LivingEntity ? (((LivingEntity)target).getCustomName() == null ? ((LivingEntity)target).getCustomName() : target.getType().name()) : (targetName = target.getType().name());
        }
        if (this.ownParticle != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.ownParticle, player.getLocation());
        }
        if (this.targetParticle != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.targetParticle, target.getLocation());
        }
        player.sendTranslatedMessage("stun_success", "target", targetName);
        result.copyFrom(TraitResults.True());
    }
}

