/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.SlowFallTrait;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractContinousCostMagicSpellTrait;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;

public class SlowFallTrait
extends AbstractContinousCostMagicSpellTrait {
    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class, PlayerMoveEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "SlowFallTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        return "for: " + time + " seconds, mana: " + this.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait lets you fall slower.");
        return helpList;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        int otherTime;
        if (!(trait instanceof SlowFallTrait)) {
            return false;
        }
        SlowFallTrait otherTrait = (SlowFallTrait)trait;
        int time = this.everyXSeconds <= 0 ? this.durationInSeconds : this.everyXSeconds;
        int n = otherTime = otherTrait.everyXSeconds <= 0 ? otherTrait.durationInSeconds : otherTrait.everyXSeconds;
        return this.cost / (double)time <= otherTrait.cost / (double)otherTime;
    }

    @Override
    @TraitInfos(category="magic", traitName="SlowFallTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() == PlayerAction.PLAYER_MOVED) {
            RaCPlayer player = wrapper.getPlayer();
            return this.activePlayersSchedulerMap.containsKey(player.getName());
        }
        return super.canBeTriggered(wrapper);
    }

    @Override
    protected TraitResults otherEventTriggered(EventWrapper eventWrapper, TraitResults result) {
        if (eventWrapper.getEvent() instanceof PlayerMoveEvent) {
            PlayerMoveEvent playerMoveEvent = (PlayerMoveEvent)eventWrapper.getEvent();
            Player player = playerMoveEvent.getPlayer();
            if (!this.activePlayersSchedulerMap.containsKey(player.getName())) {
                return TraitResults.False();
            }
            if (playerMoveEvent.getFrom().getY() > playerMoveEvent.getTo().getY() + 0.2) {
                Vector fallVector = player.getLocation().getDirection();
                fallVector.setY(-2);
                player.setVelocity(fallVector.multiply(0.03));
                player.setFallDistance(0.0f);
                return TraitResults.False();
            }
            return TraitResults.False();
        }
        return super.trigger(eventWrapper);
    }

    @Override
    protected boolean activateIntern(RaCPlayer player) {
        return true;
    }

    @Override
    protected boolean deactivateIntern(RaCPlayer player) {
        player.getPlayer().setFallDistance(0.0f);
        return true;
    }

    @Override
    public void triggerButDoesNotHaveEnoghCostType(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() == PlayerAction.PLAYER_MOVED) {
            this.trigger(wrapper);
            return;
        }
        super.triggerButDoesNotHaveEnoghCostType(wrapper);
    }

    @Override
    protected boolean tickInternal(RaCPlayer player) {
        return true;
    }
}

