/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.PushAwayTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class PushAwayTrait
extends AbstractMagicSpellTrait {
    private int blocks = 2;
    private boolean up = false;
    private ParticleContainer targetParticles = null;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "PushAwayTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "pushes " + this.blocks + " blocks away.";
    }

    @Override
    @TraitInfos(category="magic", traitName="PushAwayTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof PushAwayTrait)) {
            return false;
        }
        PushAwayTrait otherTrait = (PushAwayTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait pushes Entities away.");
        return helpList;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="blocks", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="up", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="targetParticles", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("blocks")) {
            this.blocks = configMap.getAsInt("blocks");
        }
        if (configMap.containsKey("up")) {
            this.up = configMap.getAsBool("up");
        }
        if (configMap.containsKey("targetParticles")) {
            this.targetParticles = configMap.getAsParticleContainer("targetParticles");
        }
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Object pushbackEntity = SearchEntity.inLineOfSight(30, (LivingEntity)player.getPlayer());
        if (pushbackEntity != null && EnemyChecker.areEnemies((Entity)player.getPlayer(), pushbackEntity)) {
            String targetName = pushbackEntity.getType() == EntityType.PLAYER ? ((Player)pushbackEntity).getName() : pushbackEntity.getType().name();
            LanguageAPI.sendTranslatedMessage(player, "trait_pushaway_success", "target", targetName);
            Vector playerVector = player.getLocation().getDirection();
            if (this.up) {
                playerVector.copy(new Vector());
                playerVector.setY(this.blocks);
            } else {
                playerVector.setY(0);
                playerVector.multiply(this.blocks);
                playerVector.setY(0.2);
            }
            if (this.targetParticles != null) {
                Vollotile.get().sendOwnParticleEffectToAll(this.targetParticles, pushbackEntity.getLocation());
            }
            pushbackEntity.setVelocity(playerVector);
            result.setTriggered(true);
            return;
        }
        result.setTriggered(false);
    }
}

