/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.PullToSelfTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerInteractEvent;

public class PullToSelfTrait
extends AbstractMagicSpellTrait {
    private int range = 0;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "PullToSelfTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "pulls enemy " + this.range + " blocks away to you.";
    }

    @Override
    @TraitInfos(category="magic", traitName="PullToSelfTrait", visible=true)
    public void importTrait() {
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof PullToSelfTrait)) {
            return false;
        }
        PullToSelfTrait otherTrait = (PullToSelfTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait pulls Entities to oneself.");
        return helpList;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="range", classToExpect=Integer.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.range = configMap.getAsInt("range");
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Object pullEntity = SearchEntity.inLineOfSight(this.range, (LivingEntity)player.getPlayer());
        if (pullEntity != null) {
            LanguageAPI.sendTranslatedMessage(player, "success");
            Location newLoc = player.getLocation().add(player.getLocation().getDirection().normalize());
            pullEntity.teleport(newLoc);
            result.setTriggered(true);
            return;
        }
        result.setTriggered(false);
    }
}

