/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.PickupItemTrait;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;

public class PickupItemTrait
extends AbstractMagicSpellTrait {
    private int blocks = 0;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "PickupItemTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "picks item " + this.blocks + " blocks away up";
    }

    @Override
    @TraitInfos(category="magic", traitName="PickupItemTrait", visible=true)
    public void importTrait() {
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="blocks", classToExpect=Integer.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.blocks = (Integer)configMap.get("blocks");
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof PickupItemTrait)) {
            return false;
        }
        PickupItemTrait otherTrait = (PickupItemTrait)trait;
        return this.cost > otherTrait.cost;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait picks Items up.");
        return helpList;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        List blocks = player.getPlayer().getLineOfSight(new HashSet(), 30);
        List nearEntities = player.getPlayer().getNearbyEntities(30.0, 30.0, 30.0);
        Item pickupItem = null;
        block0: for (Block block : blocks) {
            for (Entity nearEntity : nearEntities) {
                if (!(nearEntity instanceof Item) || !(block.getLocation().distance(nearEntity.getLocation()) < 1.0)) continue;
                pickupItem = (Item)nearEntity;
                continue block0;
            }
        }
        if (pickupItem != null) {
            ItemStack item = pickupItem.getItemStack();
            PlayerPickupItemEvent event = new PlayerPickupItemEvent(player.getPlayer(), pickupItem, 10);
            this.plugin.fireEventToBukkit((Event)event);
            if (event.isCancelled()) {
                result.setTriggered(false);
                return;
            }
            if (player.getPlayer().getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
                LanguageAPI.sendTranslatedMessage(player, "trait_pickup_success");
                pickupItem.remove();
                result.setTriggered(true);
                return;
            }
            LanguageAPI.sendTranslatedMessage(player, "trait_pickup_inv_full");
            result.setTriggered(false);
            return;
        }
        result.setTriggered(false);
    }
}

