/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.defaultraits.magic.MagicSpellsSpellTrait;

import com.nisovin.magicspells.MagicSpells;
import com.nisovin.magicspells.Spell;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.NeedsOtherPlugins;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;

@NeedsOtherPlugins(neededPlugins={"MagicSpells"})
public class MagicSpellsSpellTrait
extends AbstractMagicSpellTrait
implements Listener {
    private String magicSpellName;

    @Override
    public String getName() {
        return "MagicSpellsSpellTrait";
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="name", classToExpect=String.class, optional=false)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("name")) {
            this.magicSpellName = configMap.getAsString("name");
        }
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "This trait Sets a permission.");
        return helpList;
    }

    @Override
    @TraitInfos(category="passive", traitName="MagicSpellsSpellTrait", visible=true)
    public void importTrait() {
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "Cast magic spell: " + this.magicSpellName;
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return false;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (Bukkit.getPluginManager().getPlugin("MagicSpells") == null) {
            return false;
        }
        return super.canBeTriggered(wrapper);
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        if (Bukkit.getPluginManager().getPlugin("MagicSpells") == null) {
            return;
        }
        MagicSpells magicSpells = MagicSpells.getInstance();
        if (magicSpells == null) {
            return;
        }
        Spell spell = MagicSpells.getSpellByInGameName((String)this.magicSpellName);
        if (spell == null) {
            spell = MagicSpells.getSpellByInternalName((String)this.magicSpellName);
        }
        if (spell == null) {
            result.copyFrom(TraitResults.False());
            return;
        }
        Spell.SpellCastResult spellResult = spell.cast(player.getPlayer());
        if (spellResult.state == Spell.SpellCastState.NORMAL) {
            result.copyFrom(TraitResults.True());
        } else {
            result.copyFrom(TraitResults.False());
        }
    }
}

